import req from "@/request.js";

const portal = window.context.portal;
export default {
    // 获取视频目录
    getVideoF(data, cb) {
        req.post(portal + `/biz/catalog/base/getCataLogBase`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 获取视频目录树
    getVideoTree(data, cb) {
        req.post(portal + `/biz/catalog/base/getTree`, data).then(rep => {
            cb(rep.data);
        });
    },
    //点击树获取分页
    getList(data, cb) {
        req.post(portal + `/biz/catalog/base/query`, data).then(rep => {
            cb(rep.data);
        });
    },
    //获取分关监控点联页，不分页
    getListPage(data, cb) {
        req.post(portal + `/biz/catalog/base/findByZoneCode`, data).then(rep => {
            cb(rep.data);
        });
    },
    //同步检测点信息
    getSynch(data, cb) {
        req.post(portal + `/biz/catalog/base/asycZoneRes`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 水库关联监控点
    relationAd(data, cb) {
        req.post(portal + `/att/res/base/bindVideo`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 水电站关联监控点
    relationHyd(data, cb) {
        req.post(portal + `/att/hyst/base/bindVideo`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 河流关联监控点
    relationRv(data, cb) {
        req.post(portal + `/att/rv/base/bindVideo`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 根据Id获取已关联的监控点
    RvdetailRelation(id, cb) {
        req.get(portal + `/att/rv/base/getVideoList/` + id).then(rep => {
            cb(rep.data);
        });
    },

    // 根据id获取已关联的监控点
    detailRelation(id, cb) {
        req.get(portal + `/att/res/base/getVideoList/` + id).then(rep => {
            cb(rep.data);
        });
    },

    // 根据id获取已关联的水电监控点
    HyddetailRelation(id, cb) {
        req.get(portal + `/att/hyst/base/getVideoList/` + id).then(rep => {
            cb(rep.data);
        });
    },
    // 应用配置
    stationRelation(data, cb) {
        req.post(portal + `/biz/catalog/base/setApptype`, data).then(rep => {
            cb(rep.data);
        });
    },
    //同步数据
    asycCataLog(cb) {
        req.post(portal + `/biz/catalog/base/asycCataLog`).then(rep => {
            cb(rep.data);
        });

    },
    //根据目录信息同步海康区域信息
    asycCataLogZone(data, cb) {
        req.post(portal + `/biz/catalog/base/asycCataLogZone`, data).then(rep => {
            cb(rep.data);
        });
    },
    //保存应用配置
    setApptype(data, cb) {
        req.post(portal + `/biz/catalog/base/setApptype`, data).then(rep => {
            cb(rep.data);
        });
    }
}