/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.tcp.gateway.device;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.jetlinks.community.gateway.monitor.DeviceGatewayMonitor;
import org.jetlinks.community.network.tcp.TcpMessage;
import org.jetlinks.community.network.tcp.client.TcpClient;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSession;
import reactor.core.publisher.Mono;

class TcpDeviceSession
implements DeviceSession {
    private DeviceOperator operator;
    private TcpClient client;
    private final Transport transport;
    private long lastPingTime = System.currentTimeMillis();
    private final long connectTime = System.currentTimeMillis();
    private final DeviceGatewayMonitor monitor;

    TcpDeviceSession(DeviceOperator operator, TcpClient client, Transport transport, DeviceGatewayMonitor monitor) {
        this.operator = operator;
        this.client = client;
        this.transport = transport;
        this.monitor = monitor;
    }

    public String getId() {
        return this.getDeviceId();
    }

    public String getDeviceId() {
        return this.operator.getDeviceId();
    }

    public long lastPingTime() {
        return this.lastPingTime;
    }

    public long connectTime() {
        return this.connectTime;
    }

    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        this.monitor.sentMessage();
        return this.client.send(new TcpMessage(encodedMessage.getPayload()));
    }

    public void close() {
        this.client.shutdown();
    }

    public void ping() {
        this.lastPingTime = System.currentTimeMillis();
        this.client.keepAlive();
    }

    public void setKeepAliveTimeout(Duration timeout) {
        this.client.setKeepAliveTimeout(timeout);
    }

    public boolean isAlive() {
        return this.client.isAlive();
    }

    public Optional<InetSocketAddress> getClientAddress() {
        return Optional.ofNullable(this.client.getRemoteAddress());
    }

    public void onClose(Runnable call) {
        this.client.onDisconnect(call);
    }

    public boolean isChanged(DeviceSession another) {
        if (another.isWrapFrom(TcpDeviceSession.class)) {
            return !this.client.equals(((TcpDeviceSession)another.unwrap(TcpDeviceSession.class)).client);
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TcpDeviceSession session = (TcpDeviceSession)o;
        return Objects.equals(this.client, session.client);
    }

    public int hashCode() {
        return Objects.hash(this.client);
    }

    public DeviceOperator getOperator() {
        return this.operator;
    }

    public void setOperator(DeviceOperator operator) {
        this.operator = operator;
    }

    public void setClient(TcpClient client) {
        this.client = client;
    }

    public Transport getTransport() {
        return this.transport;
    }
}

