/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.cache;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.cache.annotation.CachePut;
import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.ContextThread;
import com.artfess.base.util.FileUtil;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.apache.commons.lang.exception.ExceptionUtils;

public class ActivitiDefCache
implements DeploymentCache<ProcessDefinitionEntity>,
ContextThread {
    private ThreadLocal<Map<String, ProcessDefinitionEntity>> processDefinitionCacheLocal = new ThreadLocal();

    public ProcessDefinitionEntity get(String id) {
        ProcessDefinitionEntity p = this.getThreadLocalDef(id);
        if (p == null) {
            ActivitiDefCache bean = (ActivitiDefCache)AppUtil.getBean(this.getClass());
            ProcessDefinitionEntity ent = bean.getFromCache(id);
            if (ent == null) {
                return null;
            }
            this.setThreadLocalDef(ent);
            p = this.getThreadLocalDef(id);
        }
        return p;
    }

    public void add(String id, ProcessDefinitionEntity object) {
        ActivitiDefCache bean = (ActivitiDefCache)AppUtil.getBean(this.getClass());
        bean.putInCache(id, object);
        this.setThreadLocalDef(object);
    }

    @Cacheable(value={"bpm:bpm:processEntity"}, key="#id", ignoreException=false)
    public ProcessDefinitionEntity getFromCache(String id) {
        return null;
    }

    @CachePut(value={"bpm:bpm:processEntity"}, key="#id", ignoreException=false)
    public ProcessDefinitionEntity putInCache(String id, ProcessDefinitionEntity object) {
        return object;
    }

    @CacheEvict(value={"bpm:bpm:processEntity"}, key="#id", ignoreException=false)
    public void remove(String id) {
        this.clearProcessDefinitionEntity(id);
    }

    @CacheEvict(value={"bpm:bpm:processEntity"}, allEntries=true, ignoreException=false)
    public void clear() {
        this.clearProcessCache();
    }

    public void cleanAll() {
        this.clearProcessCache();
    }

    private void clearProcessDefinitionEntity(String defId) {
        this.processDefinitionCacheLocal.remove();
    }

    private void clearProcessCache() {
        this.processDefinitionCacheLocal.remove();
    }

    private void setThreadLocalDef(ProcessDefinitionEntity process) {
        ProcessDefinitionEntity cloneEnt = null;
        try {
            cloneEnt = (ProcessDefinitionEntity)((Object)FileUtil.cloneObject((Object)((Object)process)));
        }
        catch (Exception e) {
            throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        if (this.processDefinitionCacheLocal.get() == null) {
            HashMap<String, ProcessDefinitionEntity> map = new HashMap<String, ProcessDefinitionEntity>();
            map.put(cloneEnt.getId(), cloneEnt);
            this.processDefinitionCacheLocal.set(map);
        } else {
            Map<String, ProcessDefinitionEntity> map = this.processDefinitionCacheLocal.get();
            map.put(cloneEnt.getId(), cloneEnt);
        }
    }

    private ProcessDefinitionEntity getThreadLocalDef(String processDefinitionId) {
        if (this.processDefinitionCacheLocal.get() == null) {
            return null;
        }
        Map<String, ProcessDefinitionEntity> map = this.processDefinitionCacheLocal.get();
        if (!map.containsKey(processDefinitionId)) {
            return null;
        }
        return map.get(processDefinitionId);
    }
}

