/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.documentLibrary.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.documentLibrary.dao.FileLibraryDao;
import com.artfess.cqxy.documentLibrary.manager.FileLibraryManager;
import com.artfess.cqxy.documentLibrary.manager.FileLibraryTypeManager;
import com.artfess.cqxy.documentLibrary.model.FileLibrary;
import com.artfess.cqxy.documentLibrary.model.FileLibraryType;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class FileLibraryManagerImpl
extends BaseManagerImpl<FileLibraryDao, FileLibrary>
implements FileLibraryManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private FileLibraryTypeManager typeManager;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;

    @Override
    public PageList<FileLibrary> queryAllByPage(QueryFilter<FileLibrary> queryFilter) {
        queryFilter.addFilter("bflt.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("bfl.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<FileLibrary> result = ((FileLibraryDao)this.baseMapper).queryAllByPage((IPage<FileLibrary>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<FileLibrary>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (FileLibrary ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    public boolean saveOrUpdate(FileLibrary entity) {
        ArrayList<Accessory> flag;
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        FileLibraryType type = entity.getTypeInfo();
        Assert.notNull((Object)((Object)type), (String)"\u8282\u70b9\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)type.getHasChildren(), (String)"\u662f\u5426\u6709\u5b50\u8282\u70b9\u7684\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)type.getCode(), (String)"\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)type.getName(), (String)"\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)type.getPcode(), (String)"\u7236\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.typeManager.saveOrUpdate((Object)type);
        entity.setTypeId(type.getId());
        boolean op = super.saveOrUpdate((Object)entity);
        if (!this.typeManager.checkHasChild(type.getId())) {
            this.typeManager.changeHasChildNode(type.getId(), true);
        }
        ArrayList<Accessory> accessoryList = null == (flag = entity.getAccessoryInfo()) ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setDirectory(ProjectStatusEnum.eight.getCode());
            ele.setGroup("FileLibrary");
            ele.setNode(ProjectStatusEnum.eight.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return op;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, FileLibrary entity) {
        globalRetrieval.setProjectId("");
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.thirtyTwo.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.thirtyTwo.getName());
        globalRetrieval.setBizTableName(FunctionEnum.thirtyTwo.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.thirtyTwo.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.thirtyTwo.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.thirtyTwo.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.thirtyTwo.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.thirtyTwo.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getDocumentNumber());
        globalRetrieval.setName(entity.getEstablishmentName());
        globalRetrieval.setSearchTitle(entity.getEstablishmentName() + "_" + entity.getDocumentNumber() + "_" + entity.getDescribe() + "_" + entity.getRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(String ids) {
        boolean hasChildren;
        List<String> idList = Arrays.asList(ids.split(","));
        String typeId = "";
        if (idList.size() > 0) {
            typeId = ((FileLibrary)((Object)((FileLibraryDao)this.baseMapper).selectById((Serializable)((Object)idList.get(0))))).getTypeId();
        }
        boolean op = super.removeByIds(idList);
        boolean bl = hasChildren = ((FileLibraryDao)this.baseMapper).selectList((Wrapper)new QueryWrapper().eq((Object)"TYPE_ID_", (Object)typeId)).size() > 0;
        if (!hasChildren) {
            this.typeManager.changeHasChildNode(typeId, false);
        }
        for (String ele : idList) {
            this.grm.remove(1, ele);
        }
        return op;
    }

    public FileLibrary get(Serializable id) {
        FileLibrary result = (FileLibrary)super.get(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(String.valueOf(id)));
        return result;
    }
}

