import utils from "@/hotent-ui-util.js"
import req from "@/request.js";
const portal = window.context.xqhk;

export default {
    //定时计划禁用触发器
    toggleTriggerRun(triggerName) {
        return new Promise((resolve, reject) => {
          req
            .post(portal + "/job/scheduler/v1/toggleTriggerRun?name=" + triggerName)
            .then(
              response => {
                resolve(response.data);
              },
              error => {
                reject(error);
              }
            );
        });
      },
        //定时计划删除触发器
  delTrigger(triggerName) {
    return new Promise((resolve, reject) => {
      req
        .remove(portal + "/job/scheduler/v1/delTrigger?name=" + triggerName)
        .then(
          response => {
            resolve(response.data);
          },
          error => {
            reject(error);
          }
        );
    });
  },
    getSysTypeByCatId(catId) {
        // return sysType.getSysTypeByCatId();
        return  new Promise((resolve) => {
            req.request({
                url: `${portal}/sys/sysType/v1/getByParentId?catId=${catId}`
            }).then(response=>{
                resolve(utils.tile2nest(response.data));
            });
        });
    },
    getTypesByKey(typeKey) {
        return  new Promise((resolve) => {
            req.request({
                url: `${portal}/sys/sysType/v1/getTypesByKey?typeKey=${typeKey}`
            }).then(response=>{
                resolve(utils.tile2nest(response.data));
            });
        });
    },
    getUserRelByTypeId(typeId) {
        return  new Promise((resolve) => {
            req.request({
                url: `${portal}/api/userRel/v1/userRels/getUserRelByTypeId?typeId=${typeId}`
            }).then(response=>{
                resolve(utils.tile2nest(response.data));
            });
        });
    }
}
