export declare enum EmployeeKeyTypeEnum {
    CODE = "code",
    ACCOUNTID = "accountId"
}
export declare enum KeyTypeEnum {
    CODE = "code",
    id = "id"
}
export interface ComplexPickerAdminParams {
    corpId?: string;
    title?: string;
    appId?: string;
    roleName?: string;
    multiple?: boolean;
    users?: Array<string>;
    maxUsers?: number;
    maxDepartments?: number;
    maxStripOrgs?: number;
    maxSystemTags?: number;
    maxRoleTags?: number;
    limitTips?: string;
    searchPlaceholder?: string;
    pickedUsers?: string[] | {
        [key: string]: any;
    }[];
    pickedDepartments?: string[] | {
        [key: string]: any;
    }[];
    pickedStripOrgs?: {
        [key: string]: any;
    }[];
    pickedSystemTags?: string[] | {
        [key: string]: any;
    }[];
    pickedRoleTags?: string[] | {
        [key: string]: any;
    }[];
    permissionType?: string;
    employeeKeyType?: EmployeeKeyTypeEnum;
    organizationKeyType?: KeyTypeEnum;
    tagKeyType?: KeyTypeEnum;
    normalTagKeyType?: KeyTypeEnum;
    openSearch?: boolean;
    locale?: string;
    canShowSelectOrg?: boolean;
    canSelectTag?: boolean;
    canSelectStripOrg?: boolean;
    needSelectUser?: boolean;
    canSelectOrg?: boolean;
    canSelectNormalTag?: boolean;
    limitOrganization?: string;
    limitOrganizationParamType?: string;
    disabledUsers?: string[];
    disabledDepartments?: string[];
    requiredUsers?: string[];
    requiredDepartments?: string[];
}
export interface ComplexPickerAdminResult {
    selectedCount: number;
    users: {
        name: string;
        avatar: string;
        empId: string;
    }[];
    departments: {
        name: string;
        id: string;
        number: number;
    }[];
    stripOrgs: {
        [key: string]: any;
    }[];
    systemTags: {
        [key: string]: any;
    }[];
    normalTags: {
        [key: string]: any;
    }[];
}
declare function complexPickerAdmin(args: ComplexPickerAdminParams): Promise<ComplexPickerAdminResult>;
declare namespace complexPickerAdmin {
    var version: {
        pc: string;
    };
}
export default complexPickerAdmin;
