package com.artfess.uc.params.user;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.artfess.base.annotation.ExcelColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ExcelDataVo {
	
	@ApiModelProperty(name = "orgName", notes = "组织单元名称", required = true)
    @ExcelColumn(value = "orgName", col = 0)
	protected String orgName;
	
	@ApiModelProperty(name = "name", notes = "姓名", required = true)
    @ExcelColumn(value = "name", col = 1)
	protected String name;
	
	@ApiModelProperty(name = "sex", notes = "性别", required = false)
    @ExcelColumn(value = "sex", col = 2)
	protected String sex;
	
	@ApiModelProperty(name = "mobile", notes = "手机号码", required = false)
    @ExcelColumn(value = "mobile", col = 3)
	protected String mobile;
	
	@ApiModelProperty(name = "account", notes = "账号", required = true)
    @ExcelColumn(value = "account", col = 4)
	protected String account;
	
	@ApiModelProperty(name = "status", notes = "员工状态", required = true)
    @ExcelColumn(value = "status", col = 5)
	protected String status;
	
	@ApiModelProperty(name = "address", notes = "地址", required = false)
    @ExcelColumn(value = "address", col = 6)
	protected String address;
	
	@ApiModelProperty(name = "post", notes = "岗位", required = false)
    @ExcelColumn(value = "post", col =7)
	protected String post;
	
	@ApiModelProperty(name = "job", notes = "职务", required = false)
    @ExcelColumn(value = "job", col =8)
	protected String job;
	
	@ApiModelProperty(name = "weixin", notes = "微信号", required = false)
    @ExcelColumn(value = "weixin", col =9)
	protected String weixin;
	
	@ApiModelProperty(name = "email", notes = "邮箱", required = false)
    @ExcelColumn(value = "email", col =10)
	protected String email;
	
	@ApiModelProperty(name = "charge", notes = "部门负责人", required = true)
    @ExcelColumn(value = "charge", col =11)
	protected String charge;
	
	@ApiModelProperty(name = "mainOrg", notes = "是否主组织", required = true)
    @ExcelColumn(value = "mainOrg", col =12)
	protected String mainOrg;
	
	@ApiModelProperty(name = "userNumber", notes = "工号", required = false)
    @ExcelColumn(value = "userNumber", col =13)
	protected String userNumber;
	
	@ApiModelProperty(name = "education", notes = "学历", required = false)
    @ExcelColumn(value = "education", col =14)
	protected String education;
	
	@ApiModelProperty(name = "idCard", notes = "身份证号", required = false)
    @ExcelColumn(value = "idCard", col =15)
	protected String idCard;
	
	@ApiModelProperty(name = "birth", notes = "生日", required = false)
    @ExcelColumn(value = "birth", col =16)
	protected Date birth;
	
	
	@ApiModelProperty(name = "entryDate", notes = "入职日期", required = false)
    @ExcelColumn(value = "entryDate", col =17)
	protected Date entryDate;
	
	@ApiModelProperty(name = "phone", notes = "电话", required = false)
    @ExcelColumn(value = "phone", col =18)
	protected String phone;
	
	

	public ExcelDataVo() {
	}
	
	public ExcelDataVo(String orgName,String name,String sex,String mobile,String account,String status,String address,String post,String job
			,String weixin,String email,String charge,String mainOrg,String userNumber,String education,String idCard,Date birth,Date entryDate,String phone) {
		this.orgName = orgName;
		this.name = name;
		this.sex = sex;
		this.mobile = mobile;
		this.account = account;
		this.status = status;
		this.address = address;
		this.post = post;
		this.job = job;
		this.weixin = weixin;
		this.email = email;
		this.charge = charge;
		this.mainOrg = mainOrg;
		this.userNumber = userNumber;
		this.education = education;
		this.idCard = idCard;
		this.entryDate = entryDate;
		this.phone = phone;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getSex() {
		return sex;
	}

	public void setSex(String sex) {
		this.sex = sex;
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public String getAccount() {
		return account;
	}

	public void setAccount(String account) {
		this.account = account;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getPost() {
		return post;
	}

	public void setPost(String post) {
		this.post = post;
	}

	public String getJob() {
		return job;
	}

	public void setJob(String job) {
		this.job = job;
	}

	public String getWeixin() {
		return weixin;
	}

	public void setWeixin(String weixin) {
		this.weixin = weixin;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getCharge() {
		return charge;
	}

	public void setCharge(String charge) {
		this.charge = charge;
	}

	public String getMainOrg() {
		return mainOrg;
	}

	public void setMainOrg(String mainOrg) {
		this.mainOrg = mainOrg;
	}

	public String getUserNumber() {
		return userNumber;
	}

	public void setUserNumber(String userNumber) {
		this.userNumber = userNumber;
	}

	public String getEducation() {
		return education;
	}

	public void setEducation(String education) {
		this.education = education;
	}

	public String getIdCard() {
		return idCard;
	}

	public void setIdCard(String idCard) {
		this.idCard = idCard;
	}

	public Date getBirth() {
		return birth;
	}

	public void setBirth(Date birth) {
		this.birth = birth;
	}

	public Date getEntryDate() {
		return entryDate;
	}

	public void setEntryDate(Date entryDate) {
		this.entryDate = entryDate;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}
	
}
