package com.artfess.uc.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.AutoFillModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.xml.bind.annotation.XmlTransient;

/**
 * 电子签章实体类
 *
 * @author lhq
 * @Date 2020/10/19
 */
@TableName("uc_electronic_seal")
@ApiModel(value = "ElectronicSeal", description = "电子签章")
public class ElectronicSeal extends AutoFillModel<ElectronicSeal> {

    private static final long serialVersionUID = 1L;
    @XmlTransient
    @TableId("ID_")
    @ApiModelProperty(value = "主键")
    protected String id;

    @XmlTransient
    @TableField("USER_ID_")
    @ApiModelProperty("用户ID")
    protected String userId;

    @XmlTransient
    @TableField("FILE_ID_")
    @ApiModelProperty("签章图片ID")
    protected String fileId;

    @XmlTransient
    @TableField("PASSWORD_")
    @ApiModelProperty("使用密码")
    protected String password;

    @XmlTransient
    @TableField("IS_USE_")
    @ApiModelProperty("当前是否使用")
    protected Integer isUse;

    @TableField(exist = false)
    protected String oldPassWord;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getIsUse() {
        return isUse;
    }

    public void setIsUse(Integer isUse) {
        this.isUse = isUse;
    }

    public String getOldPassWord() {
        return oldPassWord;
    }

    public void setOldPassWord(String oldPassWord) {
        this.oldPassWord = oldPassWord;
    }
    @Override
    public String toString() {
        return "ElectronicSeal{" +
                "id='" + id + '\'' +
                ", userId='" + userId + '\'' +
                ", fileId='" + fileId + '\'' +
                ", password='" + password + '\'' +
                ", isUse='" + isUse + '\'' +
                '}';
    }
}
