package com.artfess.dataAccess.dao;

import com.artfess.dataAccess.model.DataAccessDefined;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 数据权限定义 Mapper 接口
 *
 * @author llj
 * @since 2021-04-01
 */
public interface DataAccessDefinedDao extends BaseMapper<DataAccessDefined> {

    /**
     * @param
     * @Description: 查詢人員指定接口的查询范围
     * @Return: java.util.List<java.util.Map < java.lang.String, java.lang.Object>>
     * @Author: llj
     * @Date: 2021/4/2 14:54
     */
    List<Map<String, Object>> selectAccessDefinedList(HashMap<String, Object> params);

    //根据用户id查询
    List<String> queryRangNameByUser(@Param("userIds") List<String> userIds);

    List<String> queryRangNameByOrg(@Param("orgIds") List<String> orgIds);

    List<String> queryRangNameByRole(@Param("roleIds") List<String> roles);
    //查询受控类型

}
