package com.artfess.portal.persistence.manager.impl;

import com.mzt.logapi.service.IParseFunction;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @program: edp
 * @Date: 2021/3/10 16:43
 * @Author: baseli
 * @Description: 自定义请求时间获取函数
 */
@Component
public class EsLogDateFunction implements IParseFunction {
    @Override
    public String functionName() {
        //函数调用的名称
        return "GetTime";
    }

    @Override
    public String apply(String value) {
        //可以将以json对象传入
        //if(StringUtils.isEmpty(value)){
        //}
        //返回指定信息
        //return value;
        String timeStr = LocalDateTime.now().toString().replace("T", " ");
        return "时间["+timeStr+"]";
    }
}
