package com.artfess.portal.kh.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.portal.kh.dao.KhAssessSchemeDao;
import com.artfess.portal.kh.manager.KhAssessDetailsManager;
import com.artfess.portal.kh.manager.KhAssessSchemeManager;
import com.artfess.portal.kh.model.KhAssessDetails;
import com.artfess.portal.kh.model.KhAssessScheme;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 考核评级方案 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-02-20
 */
@Service
public class KhAssessSchemeManagerImpl extends BaseManagerImpl<KhAssessSchemeDao, KhAssessScheme> implements KhAssessSchemeManager {

    @Autowired
    private KhAssessDetailsManager detailsManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean createInfo(KhAssessScheme t) {
        t.setStatus("0");
        boolean save = this.save(t);
        if(save) {
            processDetail(t);
            return save;
        }
        return false;
    }

    private void processDetail(KhAssessScheme t) {
        LambdaQueryWrapper<KhAssessDetails> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(KhAssessDetails::getAssessId, t.getId());
        lambdaQueryWrapper.eq(KhAssessDetails::getIsDele, DelStatusEnum.N.getType());
        detailsManager.remove(lambdaQueryWrapper);
        if(CollectionUtils.isEmpty(t.getDetailsList())){
            return;
        }
        t.getDetailsList().forEach(detail -> {
            Assert.notNull(detail.getMinValue(), "请填写最小值");
            Assert.notNull(detail.getMaxValue(), "请填写最大值");
            detail.setAssessId(t.getId());
        });
        detailsManager.saveBatch(t.getDetailsList());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(KhAssessScheme t) {
        boolean save = this.updateById(t);
        if(save) {
            processDetail(t);
            return save;
        }
        return false;
    }

    @Override
    public KhAssessScheme findById(String id) {
        KhAssessScheme khAssessScheme = this.get(id);
        Assert.notNull(khAssessScheme, "评级方案不存在");
        LambdaQueryWrapper<KhAssessDetails> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(KhAssessDetails::getAssessId, id);
        lambdaQueryWrapper.eq(KhAssessDetails::getIsDele, DelStatusEnum.N.getType());
        List<KhAssessDetails> list = detailsManager.list(lambdaQueryWrapper);
        khAssessScheme.setDetailsList(list);
        return khAssessScheme;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateStatus(List<String> ids, String status) {
        LambdaQueryWrapper<KhAssessScheme> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(KhAssessScheme::getId, ids);
        List<KhAssessScheme> list = this.list(lambdaQueryWrapper);
        list.forEach(khAssessScheme -> {
            khAssessScheme.setStatus(status);
        });
        boolean b = this.updateBatchById(list);
        return b;
    }
}
