package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 取水用途
 */
@Getter
public enum WaterPurposeEnum {
    /**
     * 删除
     */
    ONE("1", "生活用水"),
    TWO("2", "工业用水"),
    THREE("3", "农田灌溉用水"),
    FOUR("4", "林业用水"),
    FIVE("5", "畜牧业用水"),
    SIX("6","渔业用水"),
    SEVEN("7","建筑业用水"),
    EIGHT("8","服务业用水"),
    NINE("9","生态和环境用水"),
    TEN("10","火电和其他发电用水"),
    ELEVEN("11","制水供水"),
    TWELVE("12","原水供水"),
    THIRTEEN("13","河道内生产用水-水力发电"),
    FOURTEEN("14","河道内生产用水-河道内养殖"),
    FIFTEEN("15","河道内生产用水-航运"),
    SIXTEEN("16","河道内生产用水-河道内其它"),
    SEVENTEEN("99","其他用水"),

    ;

    WaterPurposeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;



    public static String getLevel(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        WaterPurposeEnum[] values = values();
        StringBuffer sb = new StringBuffer();
        String[] split = desc.split(",");
        for (WaterPurposeEnum state : values) {

            for(String s : split){

                if (state.getDesc().equals(s)) {
                    sb.append(",");
                    sb.append(state.getType());
                }
            }
        }
        if(sb.length() > 0){
            return sb.substring(1);
        }
        return null;
    }

}
