package com.artfess.base.feign.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 消息配置实体对象
 *
 * @company artfess
 * @author wangping
 * @date 2021-06-18 17:49:50
 */
@Data
@ApiModel(description="消息配置实体对象dto")
public class MessageConfigDto{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(name="id", notes="主键")
    protected String id;

    @ApiModelProperty(name="name", notes="配置名称")
    protected String name;

    @ApiModelProperty(name="code", notes="配置编码")
    protected String code;

    @ApiModelProperty(name="tplKey", notes="模板业务键")
    protected String tplKey;

    @ApiModelProperty(name="notifyType", notes="消息提醒方式(voice: '语音', mail: '邮件', sms: '短信', inner: '站内消息')，多个用“,”号隔开")
    protected String notifyType;

    @ApiModelProperty(name="userConfigType", notes="接收人配置方式(1:动态，2：固定)")
    protected Short userConfigType;

    @ApiModelProperty(name="userStr", notes="接收人配置信息（动态配置：el表达式；固定方式：json格式字符串）")
    protected String userStr;

    @ApiModelProperty(name="userId", notes="用户id")
    protected String userId;

    @ApiModelProperty(name="orgId", notes="组织id")
    protected String orgId;

    @ApiModelProperty(name="description", notes="描述")
    protected String description;

    @ApiModelProperty(name="categoryName", notes="分类名")
    protected String categoryName;

    @ApiModelProperty(name="templateName", notes="模板名")
    protected String templateName;

}
