package com.artfess.application.jms.impl;


import com.artfess.application.config.AppPushConfig;
import com.artfess.application.model.AppPushContent;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.vo.ClientInfo;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.exceptions.RequestException;
import com.gexin.rp.sdk.http.IGtPush;
import com.gexin.rp.sdk.template.AbstractTemplate;
import com.gexin.rp.sdk.template.NotificationTemplate;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import com.gexin.rp.sdk.template.style.Style0;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * app消息的推送 （个推）
 * 
 * @author pangquan
 * @date 2020-07-30
 *
 */
@Service
public class AppPushHandler {
	private static final Logger logger = LoggerFactory.getLogger(AppPushHandler.class);
	
	@Resource
	AppPushConfig config;
	
	public void pushIndexMsgToList(AppPushContent content, ClientInfo...clientInfo){
		
	}
	/**
	 * 给设备推送通知消息 - 打开应用首页
	 * 
	 * @param clientInfo
	 * @param content
	 * @throws IOException 
	 */
	public void pushIndexMsgToSingle(ClientInfo clientInfo, AppPushContent content) throws IOException {
		IGtPush push = new IGtPush(config.getHost(), config.getAppKey(), config.getMasterSecret());
		AbstractTemplate template = this.getIndexMsgTemplate(content.getTitle(), content.getContent(), JsonUtil.toJson(content.getParams()));
		SingleMessage message = new SingleMessage();
		// 设置消息离线
		message.setOffline(true);
		// 离线有效时间，单位为毫秒
		message.setOfflineExpireTime(72 * 3600 * 1000);
		message.setData(template);
		// 可选，1为wifi，0为不限制网络环境。根据手机处于的网络情况，决定是否下发
		message.setPushNetWorkType(0);
		// 厂商通道下发策略
		message.setStrategyJson("{\"default\":4,\"ios\":4,\"st\":4,\"hw\":4,\"xm\":4,\"vv\":4,\"mz\":4,\"op\":4}");
		
		Target target = new Target();
		target.setAppId(config.getAppId());
		target.setClientId(clientInfo.getClientId());
		IPushResult ret = null;

		try {
			ret = push.pushMessageToSingle(message, target);
		} catch (RequestException e) {
			logger.error("服务器异常，app推送消息失败："+ ExceptionUtils.getStackTrace(e));
			ret = push.pushMessageToSingle(message, target, e.getRequestId());
		}
		if (ret != null) {
			logger.info("推送返回结果:" + ret.getResponse().toString());
			System.out.println("推送返回结果:" + ret.getResponse().toString());
		} else {
			logger.error("服务器响应异常");
		}
	}
	
	public TransmissionTemplate transmissionTemplateDemo(String title, String content, String transmissionContent) {
        TransmissionTemplate template = new TransmissionTemplate();
        template.setAppId(config.getAppId());
        template.setAppkey(config.getAppKey());
        template.setTransmissionType(2);
        template.setTransmissionContent("请输入需要透传的内容");
        //template.setAPNInfo(getAPNPayload()); //详见本页iOS通知样式设置
        return template;
    }
	

	public NotificationTemplate getIndexMsgTemplate(String title, String content, String transmissionContent) {
		NotificationTemplate template = new NotificationTemplate();
        // 设置APPID与APPKEY
        template.setAppId(config.getAppId());
        template.setAppkey(config.getAppKey());

        Style0 style = new Style0();
        // 设置通知栏标题与内容
        style.setTitle(title);
        style.setText(content);
        // 配置通知栏图标
//        style.setLogo("icon.png");
        // 配置通知栏网络图标
//        style.setLogoUrl("");
        // 设置通知是否响铃，震动，或者可清除
     // 角标, 必须大于0, 个推通道下发有效; 此属性目前仅针对华为 EMUI 4.1 及以上设备有效
        style.setBadgeAddNum(1);
        style.setRing(true);
        style.setVibrate(true);
        style.setClearable(true);
//        style.setChannel("通知渠道id");
//        style.setChannelName("通知渠道名称");
        style.setChannelLevel(4); //设置通知渠道重要性
        template.setStyle(style);

        template.setTransmissionType(2);  // 透传消息接受方式设置，1：立即启动APP，2：客户端收到消息后需要自行处理
        template.setTransmissionContent(transmissionContent);

        //template.setAPNInfo(getAPNPayload()); //详见【推送模板说明】iOS通知样式设置
        return template;
	}
	
}
