package com.artfess.ljzc.taskCallback;

import com.artfess.base.groovy.IScript;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.ljzc.business.manager.BizAssetBusinessInfoManager;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class TaskCallBackScript implements IScript {

    @Autowired
    private BizAssetBusinessInfoManager bizAssetBusinessInfoManager;

    /**
     * 流程图配置 示例：return taskCallBackScript.updateBusinessStatus(nodeDef,delegateTask,cmd);
     * 经营性资产审批状态修改
     * @param nodeDef 节点信息
     * @param delegateTask 任务信息
     * @param cmd 流转信息
     * @throws Exception
     */
    public void updateBusinessStatus(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd) throws Exception {
        //审核完成后修改审核状态
        String businessKey = cmd.getBusinessKey();
        if(StringUtils.isBlank(businessKey)){
            return;
        }
        List<String> ids = Lists.newArrayList();
        ids.add(businessKey);
        bizAssetBusinessInfoManager.audit(ids, "2", null);

    }
}
