package com.artfess.ljzc.loan.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 债权资产信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@TableName("Biz_Asset_Loan_Info")
@ApiModel(value="BizAssetLoanInfo对象", description="债权资产信息")
public class AssetLoanInfo extends AutoFillFullModel<AssetLoanInfo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "交易对象")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "交易方式")
    @TableField("deal_type_")
    private String dealType;

    @ApiModelProperty(value = "交易机构")
    @TableField("deal_org_")
    private String dealOrg;

    @ApiModelProperty(value = "合同金额（万元）")
    @TableField("contract_money_")
    private BigDecimal contractMoney;

    @ApiModelProperty(value = "年收益率(%/年)")
    @TableField("year_earnings_rate_")
    private BigDecimal yearEarningsRate;

    @ApiModelProperty(value = "还本付息方式（字典：到期还本按月计息，到期还本按季计息，到期还本按半年计息，到期还本按年计息）")
    @TableField("return_type_")
    private String returnType;

    @ApiModelProperty(value = "期限")
    @TableField("date_limit_")
    private String dateLimit;

    @ApiModelProperty(value = "起始日期")
    @TableField("start_date_")
    private LocalDate startDate;

    @ApiModelProperty(value = "到期日期")
    @TableField("end_date_")
    private LocalDate endDate;

    @ApiModelProperty(value = "风控措施")
    @TableField("risk_measures_")
    private String riskMeasures;

    @ApiModelProperty(value = "状态（字典：正常，提前还款，到期，逾期）")
    @TableField("loan_status_")
    private String loanStatus;

    @ApiModelProperty(value = "债权归属单位ID")
    @TableField("belongs_org_id_")
    private String belongsOrgId;

    @ApiModelProperty(value = "债权归属单位")
    @TableField("belongs_org_name_")
    private String belongsOrgName;

    @ApiModelProperty(value = "债权归属单位fullid")
    @TableField("belongs_org_full_id_")
    private String belongsOrgFullId;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;

    @ApiModelProperty(value = "资产审核状态（-1：驳回 0：草稿，1：待审核，2：审核通过）")
    @TableField("asset_audit_")
    private String assetAudit;


    @ApiModelProperty(value = "资产审核意见")
    @TableField("audit_msg_")
    private String auditMsg;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("is_dele_")
    private String isDele = "0";


    @ApiModelProperty(value = "债权归还利息信息")
    @TableField(exist = false)
    private List<AssetLoanInterest>  loanInterest;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDealType() {
        return dealType;
    }

    public void setDealType(String dealType) {
        this.dealType = dealType;
    }

    public String getDealOrg() {
        return dealOrg;
    }

    public void setDealOrg(String dealOrg) {
        this.dealOrg = dealOrg;
    }

    public BigDecimal getContractMoney() {
        return contractMoney;
    }

    public void setContractMoney(BigDecimal contractMoney) {
        this.contractMoney = contractMoney;
    }

    public BigDecimal getYearEarningsRate() {
        return yearEarningsRate;
    }

    public void setYearEarningsRate(BigDecimal yearEarningsRate) {
        this.yearEarningsRate = yearEarningsRate;
    }

    public String getReturnType() {
        return returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getDateLimit() {
        return dateLimit;
    }

    public void setDateLimit(String dateLimit) {
        this.dateLimit = dateLimit;
    }

    public LocalDate getStartDate() {
        return startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public String getRiskMeasures() {
        return riskMeasures;
    }

    public void setRiskMeasures(String riskMeasures) {
        this.riskMeasures = riskMeasures;
    }

    public String getLoanStatus() {
        return loanStatus;
    }

    public void setLoanStatus(String loanStatus) {
        this.loanStatus = loanStatus;
    }

    public String getBelongsOrgId() {
        return belongsOrgId;
    }

    public void setBelongsOrgId(String belongsOrgId) {
        this.belongsOrgId = belongsOrgId;
    }

    public String getBelongsOrgName() {
        return belongsOrgName;
    }

    public void setBelongsOrgName(String belongsOrgName) {
        this.belongsOrgName = belongsOrgName;
    }

    public String getBelongsOrgFullId() {
        return belongsOrgFullId;
    }

    public void setBelongsOrgFullId(String belongsOrgFullId) {
        this.belongsOrgFullId = belongsOrgFullId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAssetAudit() {
        return assetAudit;
    }

    public void setAssetAudit(String assetAudit) {
        this.assetAudit = assetAudit;
    }

    public String getAuditMsg() {
        return auditMsg;
    }

    public void setAuditMsg(String auditMsg) {
        this.auditMsg = auditMsg;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public List<AssetLoanInterest> getLoanInterest() {
        return loanInterest;
    }

    public void setLoanInterest(List<AssetLoanInterest> loanInterest) {
        this.loanInterest = loanInterest;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAssetLoanInfo{" +
            "id=" + id +
            ", name=" + name +
            ", dealType=" + dealType +
            ", dealOrg=" + dealOrg +
            ", contractMoney=" + contractMoney +
            ", yearEarningsRate=" + yearEarningsRate +
            ", returnType=" + returnType +
            ", dateLimit=" + dateLimit +
            ", startDate=" + startDate +
            ", endDate=" + endDate +
            ", riskMeasures=" + riskMeasures +
            ", loanStatus=" + loanStatus +
            ", belongsOrgId=" + belongsOrgId +
            ", belongsOrgName=" + belongsOrgName +
            ", belongsOrgFullId=" + belongsOrgFullId +
            ", remark=" + remark +
            ", assetAudit=" + assetAudit +
            ", auditMsg=" + auditMsg+
            ", isDele=" + isDele +
        "}";
    }
}
