package com.artfess.ljzc.fixed.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.ljzc.business.model.BizAssetBusinessInfo;
import com.artfess.ljzc.fixed.manager.BizAssetFixedInfoManager;
import com.artfess.ljzc.fixed.model.BizAssetFixedInfo;
import com.artfess.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;

/**
 * 固定资产信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Slf4j
@Api(tags = "固定资产-资产信息")
@RestController
@RequestMapping("/biz/assetFixedInfo/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizAssetFixedInfoController extends BaseController<BizAssetFixedInfoManager, BizAssetFixedInfo> {

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @Validated({AddGroup.class}) @RequestBody BizAssetFixedInfo t) {
        boolean result = baseService.createInfo(t);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @Override
    @GetMapping("/{id}")
    @ApiOperation("根据id查询实体")
    public BizAssetFixedInfo getById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {
        return baseService.findById(id);
    }

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<BizAssetFixedInfo> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizAssetFixedInfo> queryFilter) {
        String fullId = ContextUtil.getCurrentOrgFullId();
        queryFilter.addFilter("belongs_org_full_id_", fullId, QueryOP.RIGHT_LIKE);
        return baseService.findByPage(queryFilter);
    }

    @Override
    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name = "model", value = "实体信息") @Validated({UpdateGroup.class}) @RequestBody BizAssetFixedInfo t) {
        boolean result = baseService.updateInfo(t);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>();
    }

    @Override
    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = baseService.removeInfo(Arrays.asList(ids));
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

}
