package com.artfess.ljzc.welfare.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.ljzc.welfare.manager.AssetPublicUseManager;
import com.artfess.ljzc.welfare.manager.AssetPublicWarrentsManager;
import com.artfess.ljzc.welfare.model.AssetPubilcInfo;
import com.artfess.ljzc.welfare.dao.AssetPubilcInfoDao;
import com.artfess.ljzc.welfare.manager.AssetPubilcInfoManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.ljzc.welfare.model.AssetPublicUse;
import com.artfess.ljzc.welfare.model.AssetPublicWarrents;
import com.artfess.ljzc.welfare.vo.AssetPubilcInfoVo;
import com.artfess.uc.util.ContextUtil;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 公益资产信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Service
public class AssetPubilcInfoManagerImpl extends BaseManagerImpl<AssetPubilcInfoDao, AssetPubilcInfo> implements AssetPubilcInfoManager {

    @Autowired
    AssetPublicUseManager publicUseManager;

    @Autowired
    AssetPublicWarrentsManager publicWarrentsManager;

    @Override
    public PageList<AssetPubilcInfoVo> queryPubilcInfoVoPage(QueryFilter<AssetPubilcInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<AssetPubilcInfoVo> result = baseMapper.queryPubilcInfoVoPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<AssetPubilcInfoVo>(result);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String insertPubilcInfo(AssetPubilcInfo pubilcInfo) throws Exception {
        if(BeanUtils.isNotEmpty(pubilcInfo)){
            if(StringUtil.isEmpty(pubilcInfo.getAssetAudit())){
                pubilcInfo.setAssetAudit("0");
            }
            if(StringUtil.isEmpty(pubilcInfo.getBelongsOrgId())){
                pubilcInfo.setBelongsOrgId(ContextUtil.getCurrentOrgId());
                pubilcInfo.setBelongsOrgName(ContextUtil.getCurrentOrgName());
                pubilcInfo.setBelongsOrgFullId(ContextUtil.getCurrentOrgFullId());
            }
            this.baseMapper.insert(pubilcInfo);
            List<AssetPublicUse> uselist = pubilcInfo.getAssetPublicUse();
            List<AssetPublicWarrents> warrentslist = pubilcInfo.getAssetPublicWarrents();
            if(!CollectionUtils.isEmpty(uselist)){
                uselist.forEach(s -> {
                    s.setPublicId(pubilcInfo.getId());
                });
                this.publicUseManager.saveBatch(uselist);
            }

            if(!CollectionUtils.isEmpty(warrentslist)){
                warrentslist.forEach(s -> {
                    s.setPublicId(pubilcInfo.getId());
                });
                this.publicWarrentsManager.saveBatch(warrentslist);
            }
            return pubilcInfo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updatePubilcInfo(AssetPubilcInfo pubilcInfo) throws Exception {
        if(BeanUtils.isNotEmpty(pubilcInfo)){
            this.saveOrUpdate(pubilcInfo);
            List<AssetPublicUse> uselist = pubilcInfo.getAssetPublicUse();
            List<AssetPublicWarrents> warrentslist = pubilcInfo.getAssetPublicWarrents();

            QueryWrapper<AssetPublicUse> delUseWrapper = new QueryWrapper<>();
            delUseWrapper.eq("public_id_", pubilcInfo.getId());
            this.publicUseManager.getBaseMapper().delete(delUseWrapper);

            QueryWrapper<AssetPublicWarrents> delWarrentsWrapper = new QueryWrapper<>();
            delWarrentsWrapper.eq("public_id_", pubilcInfo.getId());
            this.publicWarrentsManager.getBaseMapper().delete(delWarrentsWrapper);

            if(!CollectionUtils.isEmpty(uselist)){
                uselist.forEach(s -> {
                    s.setPublicId(pubilcInfo.getId());
                });
                this.publicUseManager.saveOrUpdateBatch(uselist);
            }

            if(!CollectionUtils.isEmpty(warrentslist)){
                warrentslist.forEach(s -> {
                    s.setPublicId(pubilcInfo.getId());
                });
                this.publicWarrentsManager.saveOrUpdateBatch(warrentslist);
            }
            return true;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deletePubilcInfo(String id) {
        Assert.hasText(id, "请选择要删除的资产！");
        boolean flag = this.removeById(id);
        if(flag){
            QueryWrapper<AssetPublicUse> delUseWrapper = new QueryWrapper<>();
            delUseWrapper.eq("public_id_", id);
            this.publicUseManager.getBaseMapper().delete(delUseWrapper);

            QueryWrapper<AssetPublicWarrents> delWarrentsWrapper = new QueryWrapper<>();
            delWarrentsWrapper.eq("public_id_", id);
            this.publicWarrentsManager.getBaseMapper().delete(delWarrentsWrapper);
        }
        return flag;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteBachPubilcInfo(List<String> ids) {
        Assert.noNullElements(ids, "请选择要删除的资产！");
        boolean flag = this.removeByIds(ids);
        if(flag){
            QueryWrapper<AssetPublicUse> delUseWrapper = new QueryWrapper<>();
            delUseWrapper.in("public_id_", ids);
            this.publicUseManager.getBaseMapper().delete(delUseWrapper);

            QueryWrapper<AssetPublicWarrents> delWarrentsWrapper = new QueryWrapper<>();
            delWarrentsWrapper.in("public_id_", ids);
            this.publicWarrentsManager.getBaseMapper().delete(delWarrentsWrapper);
        }
        return flag;
    }

    @Override
    public AssetPubilcInfo findPubilcInfo(String id) {
        Assert.hasText(id, "请选择要查询的资产！");
        AssetPubilcInfo assetPubilcInfo = this.getById(id);
        if(BeanUtils.isNotEmpty(assetPubilcInfo)){
            QueryWrapper<AssetPublicUse> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("public_id_", id);
            queryWrapper.orderByDesc("fill_year_");
            List<AssetPublicUse> list = this.publicUseManager.list(queryWrapper);
            assetPubilcInfo.setAssetPublicUse(list);

            QueryWrapper<AssetPublicWarrents> queryWarrentsWrapper = new QueryWrapper<>();
            queryWarrentsWrapper.eq("public_id_", id);

            List<AssetPublicWarrents> warrentsList = this.publicWarrentsManager.list(queryWarrentsWrapper);
            assetPubilcInfo.setAssetPublicWarrents(warrentsList);

            return assetPubilcInfo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean auditLoan(String status, String msg, List<String> idList) {
        Assert.hasText(status, "状态不能为空！");
        Assert.notNull(idList, "请选择要审核的资产");
        Integer result = null;
        UpdateWrapper<AssetPubilcInfo> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("asset_audit_", status);
        updateWrapper.set("audit_msg_", msg);
        updateWrapper.in("id_",idList);
        result =  this.baseMapper.update(null,updateWrapper);
        return null != result && result >= 1;
    }

    @Override
    public JSONObject publicStatistics(String fullId) {
        return this.baseMapper.publicStatistics(fullId);
    }
}
