/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ljzc.stock.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.ljzc.stock.manager.AssetStockInfoManager;
import com.artfess.ljzc.stock.model.AssetStockInfo;
import com.artfess.ljzc.stock.vo.AssetStockInfoVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u80a1\u6743\u8d44\u4ea7\u4fe1\u606f"})
@ApiGroup(group={"group_biz"})
@RestController
@RequestMapping(value={"/biz/stock/stockInfo/v1/"})
public class AssetStockInfoController
extends BaseController<AssetStockInfoManager, AssetStockInfo> {
    @PostMapping(value={"/queryPageStockInfoAuthority"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u80a1\u6743\u8d44\u4ea7")
    public PageList<AssetStockInfo> queryPageCompanyAuthority(@RequestBody QueryFilter<AssetStockInfo> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            queryFilter.addFilter("belongs_org_full_id_", (Object)ContextUtil.getCurrentOrgFullId(), QueryOP.RIGHT_LIKE);
        }
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("belongs_org_id_", Direction.ASC));
        queryFilter.setSorter(sorter);
        return ((AssetStockInfoManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/insertStockInfo"})
    @ApiOperation(value="\u4fdd\u5b58\u80a1\u6743\u8d44\u4ea7")
    public CommonResult<String> insertStockInfo(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody AssetStockInfoVo assetStockInfoVo) throws Exception {
        String id = ((AssetStockInfoManager)this.baseService).insertStockInfo(assetStockInfoVo);
        if (StringUtil.isEmpty((String)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f\uff01", (Object)id);
    }

    @PostMapping(value={"/updateStockInfo"})
    @ApiOperation(value="\u4fee\u6539\u80a1\u6743\u8d44\u4ea7")
    public CommonResult<String> updateStockInfo(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody AssetStockInfoVo assetStockInfoVo) throws Exception {
        boolean result = ((AssetStockInfoManager)this.baseService).updateStockInfo(assetStockInfoVo);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/deleteStockInfo"})
    @ApiOperation(value="\u5220\u9664\u80a1\u6743\u8d44\u4ea7")
    public CommonResult<String> deleteStockInfo(@ApiParam(name="id", value="id") @RequestParam String id) {
        boolean result = ((AssetStockInfoManager)this.baseService).deleteStockInfo(id);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/deleteBachStockInfo"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u80a1\u6743\u8d44\u4ea7")
    public CommonResult<String> deleteBachStockInfo(String ... ids) {
        boolean result = ((AssetStockInfoManager)this.baseService).deleteBachStockInfo(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/findById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u80a1\u6743\u8d44\u4ea7")
    public AssetStockInfoVo findById(@RequestParam(name="id", required=true) String id) {
        AssetStockInfoVo stockInfoVo = ((AssetStockInfoManager)this.baseService).findStockInfoVo(id);
        return stockInfoVo;
    }

    @PostMapping(value={"/auditStock"})
    @ApiOperation(value="\u5ba1\u6838\u80a1\u6743\u8d44\u4ea7\u5165\u5e93")
    public CommonResult<String> auditStock(@ApiParam(name="status", value="\u5165\u5e93\u5ba1\u6838\u72b6\u6001\uff080\uff1a\u672a\u5ba1\u6838\uff0c1\uff1a\u5df2\u5ba1\u6838\uff09") @RequestParam String status, @ApiParam(name="msg", value="\u5ba1\u6838\u610f\u89c1") @RequestParam String msg, String ... ids) {
        boolean result = ((AssetStockInfoManager)this.baseService).auditStock(status, msg, Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5ba1\u6838\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/queryStockStructures"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u80a1\u6743\u5173\u7cfb\u56fe\u8c31")
    public Map<String, Object> queryStockStructures(@ApiParam(name="orgId", value="\u4f01\u4e1aID") @RequestParam String orgId, @ApiParam(name="orgName", value="\u4f01\u4e1a\u540d\u79f0") @RequestParam String orgName) {
        Map<String, Object> map = ((AssetStockInfoManager)this.baseService).queryStockStructures(orgId, orgName);
        return map;
    }
}

