package com.artfess.sysConfig.persistence.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 用户的自定义快捷菜单
 * 
 * <pre>
 *  
 * 描述：角色权限配置 实体对象
 * 构建组：x7
 * 作者:liyg
 * 邮箱:liygui@jee-soft.cn
 * 日期:2018-06-29 14:27:46
 * 版权：广州宏天软件有限公司
 * </pre>
 */
@ApiModel(description = "用户的自定义快捷菜单")
@TableName("portal_sys_swift_menu ")
public class SysSwiftMenu extends BaseModel<SysSwiftMenu> {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(name = "id", notes = "主键")
	@TableId("id_")
	protected String id;

	@ApiModelProperty(name = "userId", notes = "用户ID")
	@TableField("user_id_")
	protected String userId;

	@ApiModelProperty(name = "menuAlias", notes = "菜单别名")
	@TableField("menu_alias_")
	protected String menuAlias;

	@ApiModelProperty(name = "sn", notes = "排序")
	@TableField("sn_")
	protected Integer sn;


	public void setId(String id) {
		this.id = id;
	}

	/**
	 * 返回 主键
	 * 
	 * @return
	 */
	public String getId() {
		return this.id;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public void setMenuAlias(String menuAlias) {
		this.menuAlias = menuAlias;
	}

	/**
	 * 返回 菜单别名
	 * 
	 * @return
	 */
	public String getMenuAlias() {
		return this.menuAlias;
	}

	public Integer getSn() {
		return sn;
	}

	public void setSn(Integer sn) {
		this.sn = sn;
	}

	/**
	 * @see Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this)
				.append("id", this.id)
				.append("userId", this.userId)
				.append("menuAlias", this.menuAlias)
				.append("sn", this.sn)
				.toString();
	}
}