package com.artfess.bpm.plugin.usercalc.position.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.BpmConstants;
import com.artfess.bpm.api.constant.ExtractType;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.artfess.bpm.plugin.core.runtime.AbstractUserCalcPlugin;
import com.artfess.bpm.plugin.usercalc.position.def.PositionPluginDef;
import com.artfess.uc.api.constant.GroupTypeConstant;
import com.artfess.uc.api.impl.model.OrgRel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.service.IOrgService;

/**
 * 岗位作为审批人的插件
 *
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2018年11月18日
 */
public class PositionPlugin extends AbstractUserCalcPlugin{

	@Override
	public List<BpmIdentity> queryByPluginDef(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) {
		List<BpmIdentity> identityList=new ArrayList<BpmIdentity>();
		PositionPluginDef def = (PositionPluginDef)pluginDef;
		String posCode = "";
		String posName = "";
		String source = def.getSource();
		if(StringUtil.isEmpty(source)) return identityList;
		IOrgService orgEngine= pluginSession.getOrgEngine();
		Map<String, Object> vars= pluginSession.getVariables();
		//查找岗位
		if("startSuper".equals(source)){
			//发起人的上级岗位
			String startId=(String)vars.get(BpmConstants.START_USER);
			Object rust = orgEngine.getUserService().getSuperiorPost(startId);
			if(BeanUtils.isNotEmpty(rust)){
				JsonNode node = (JsonNode) rust;
				posCode = node.get("code").asText();
				posName = node.get("name").asText();
			}
		}else if("prevSuper".equals(source)){
			//上一步执行人的上级岗位
			String userId=ContextUtil.getCurrentUser().getUserId();;
			Object rust = orgEngine.getUserService().getSuperiorPost(userId);
			if(BeanUtils.isNotEmpty(rust)){
				JsonNode node = (JsonNode) rust;
				posCode = node.get("code").asText();
				posName = node.get("name").asText();
			}
		}else if("spec".equals(source)){
			//指定岗位
			posCode = def.getPosCode();
			posName = def.getPosName();
		}
		if(StringUtil.isEmpty(posCode)){
			return identityList;
		}
		
		boolean isReqUc = StringUtil.isEmpty((String)vars.get(BpmConstants.NOT_REQUEST_UC));
		IGroup group = null;
		if (isReqUc || ExtractType.EXACT_EXACT_USER.equals(def.getExtract())) {
			group = orgEngine.getUserGroupService().getGroupByIdOrCode(GroupTypeConstant.POSITION.key(), posCode);
		}else {
			group = buildPositionGroup(posCode, posName);
		}
		BpmIdentity bpmIdentity = getBpmIdentityConverter().convertGroup(group);
		identityList.add(bpmIdentity);
		return identityList;
	}
	
	private IGroup buildPositionGroup(String posCode, String posName) {
		OrgRel pos = new OrgRel();
		pos.setCode(posCode);
		pos.setName(posName);
		return pos;
	}
}
