package com.artfess.table.conf;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.table.factory.DatabaseFactory;
import com.artfess.table.meta.impl.BaseTableMeta;
import com.artfess.table.operator.IIndexOperator;
import com.artfess.table.operator.ITableOperator;
import com.artfess.table.operator.IViewOperator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.annotation.Resource;

@Configuration
public class DatabaseFactoryConfig {
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    DatabaseContext databaseContext;

    @Bean
    public ITableOperator initTableOperator() throws Exception {
        ITableOperator tableOperator = DatabaseFactory.getTableOperator(databaseContext.getDbType());
        tableOperator.setJdbcTemplate(jdbcTemplate);
        return tableOperator;
    }

    @Bean
    public BaseTableMeta initBaseTableMeta() throws Exception {
        BaseTableMeta tableMetaByDbType = DatabaseFactory.getTableMetaByDbType(databaseContext.getDbType());
        tableMetaByDbType.setJdbcTemplate(jdbcTemplate);
        return tableMetaByDbType;
    }

    @Bean
    public IIndexOperator initIIndexOperator() throws Exception {
        IIndexOperator indexOperator = DatabaseFactory.getIndexOperator(databaseContext.getDbType());
        indexOperator.setJdbcTemplate(jdbcTemplate);
        return indexOperator;
    }

    @Bean
    public IViewOperator initIViewOperator() throws Exception {
        IViewOperator viewOperator = DatabaseFactory.getViewOperator(databaseContext.getDbType());
        viewOperator.setJdbcTemplate(jdbcTemplate);
        return viewOperator;
    }
}
