/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ljzc.stock.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.ljzc.stock.dao.AssetStockInfoDao;
import com.artfess.ljzc.stock.manager.AssetStockInfoManager;
import com.artfess.ljzc.stock.manager.AssetStockStructureManager;
import com.artfess.ljzc.stock.model.AssetStockInfo;
import com.artfess.ljzc.stock.model.AssetStockStructure;
import com.artfess.ljzc.stock.vo.AssetStockInfoVo;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class AssetStockInfoManagerImpl
extends BaseManagerImpl<AssetStockInfoDao, AssetStockInfo>
implements AssetStockInfoManager {
    @Autowired
    private AssetStockStructureManager stockStructureManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String insertStockInfo(AssetStockInfoVo stockInfoVo) throws Exception {
        if (BeanUtils.isNotEmpty((Object)((Object)stockInfoVo))) {
            if (StringUtil.isEmpty((String)stockInfoVo.getAssetAudit())) {
                stockInfoVo.setAssetAudit("0");
            }
            if (StringUtil.isEmpty((String)stockInfoVo.getBelongsOrgId())) {
                stockInfoVo.setBelongsOrgId(ContextUtil.getCurrentOrgId());
                stockInfoVo.setBelongsOrgName(ContextUtil.getCurrentOrgName());
                stockInfoVo.setBelongsOrgFullId(ContextUtil.getCurrentOrgFullId());
            }
            ((AssetStockInfoDao)this.baseMapper).insert((Object)stockInfoVo);
            List<AssetStockStructure> list = stockInfoVo.getStructureList();
            if (!CollectionUtils.isEmpty(list)) {
                list.forEach(s -> s.setStockId(stockInfoVo.getId()));
                this.stockStructureManager.saveBatch(list);
            }
            return stockInfoVo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateStockInfo(AssetStockInfoVo stockInfoVo) throws Exception {
        if (BeanUtils.isNotEmpty((Object)((Object)stockInfoVo))) {
            this.saveOrUpdate((Object)stockInfoVo);
            List<AssetStockStructure> list = stockInfoVo.getStructureList();
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.eq((Object)"stock_id_", (Object)stockInfoVo.getId());
            this.stockStructureManager.getBaseMapper().delete((Wrapper)delWrapper);
            if (!CollectionUtils.isEmpty(list)) {
                list.forEach(s -> s.setStockId(stockInfoVo.getId()));
                this.stockStructureManager.saveOrUpdateBatch(list);
            }
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deleteStockInfo(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u8d44\u4ea7\uff01");
        boolean flag = this.removeById((Serializable)((Object)id));
        if (flag) {
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.eq((Object)"stock_id_", (Object)id);
            this.stockStructureManager.getBaseMapper().delete((Wrapper)delWrapper);
        }
        return flag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deleteBachStockInfo(List<String> ids) {
        Assert.noNullElements(ids, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u8d44\u4ea7\uff01");
        boolean flag = this.removeByIds(ids);
        if (flag) {
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.in((Object)"stock_id_", ids);
            this.stockStructureManager.getBaseMapper().delete((Wrapper)delWrapper);
        }
        return flag;
    }

    @Override
    public AssetStockInfoVo findStockInfoVo(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u67e5\u8be2\u7684\u8d44\u4ea7\uff01");
        AssetStockInfo assetStockInfo = (AssetStockInfo)((Object)this.getById((Serializable)((Object)id)));
        if (BeanUtils.isNotEmpty((Object)((Object)assetStockInfo))) {
            AssetStockInfoVo assetStockInfoVo = new AssetStockInfoVo();
            try {
                BeanUtils.copyNotNullProperties((Object)((Object)assetStockInfoVo), (Object)((Object)assetStockInfo));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"stock_id_", (Object)id);
            List list = this.stockStructureManager.list((Wrapper)queryWrapper);
            assetStockInfoVo.setStructureList(list);
            return assetStockInfoVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean auditStock(String status, String msg, List<String> idList) {
        Assert.hasText((String)status, (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull(idList, (String)"\u8bf7\u9009\u62e9\u8981\u5ba1\u6838\u7684\u8d44\u4ea7");
        Integer result = null;
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"asset_audit_", (Object)status);
        updateWrapper.set((Object)"audit_msg_", (Object)msg);
        updateWrapper.in((Object)"id_", idList);
        result = ((AssetStockInfoDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
        return null != result && result >= 1;
    }

    @Override
    public Map<String, Object> queryStockStructures(String orgId, String orgName) {
        if (StringUtil.isEmpty((String)orgId)) {
            orgId = ContextUtil.getCurrentOrgId();
            orgName = ContextUtil.getCurrentOrgName();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"belongs_org_id_", (Object)orgId);
        List stockInfoList = ((AssetStockInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", orgId);
        map.put("name", orgName);
        map.put("level", 1);
        ArrayList level2List = null;
        if (!CollectionUtils.isEmpty((Collection)stockInfoList)) {
            level2List = new ArrayList();
            for (AssetStockInfo assetStockInfo : stockInfoList) {
                QueryWrapper queryStructureWrapper = new QueryWrapper();
                queryStructureWrapper.eq((Object)"stock_id_", (Object)assetStockInfo.getId());
                List structureList = this.stockStructureManager.list((Wrapper)queryStructureWrapper);
                ArrayList level3List = null;
                HashMap<String, Object> level2Map = new HashMap<String, Object>();
                level2Map.put("id", assetStockInfo.getId());
                level2Map.put("name", assetStockInfo.getName());
                level2Map.put("level", 2);
                level2Map.put("type", 2);
                level2Map.put("equityRatio", assetStockInfo.getEquityRatio());
                if (!CollectionUtils.isEmpty((Collection)structureList)) {
                    level3List = new ArrayList();
                    for (AssetStockStructure structure : structureList) {
                        if (structure.getStockName().equals(orgName)) continue;
                        HashMap<String, Object> level3Map = new HashMap<String, Object>();
                        level3Map.put("id", structure.getId());
                        level3Map.put("name", structure.getStockName());
                        level3Map.put("level", 3);
                        level3Map.put("type", 1);
                        level3Map.put("equityRatio", structure.getEquityRatio());
                        level3List.add(level3Map);
                    }
                }
                level2Map.put("list", level3List);
                level2List.add(level2Map);
            }
        }
        map.put("list", level2List);
        return map;
    }

    @Override
    public List<JSONObject> stockStatistics(String fullId) {
        return ((AssetStockInfoDao)this.baseMapper).stockStatistics(fullId);
    }
}

