import 'element-plus/dist/index.css'
import './assets/css/theme-variables.scss'
import './assets/css/element-custom.scss'
import './assets/css/style.scss'
import * as ElementPlusIconsVue from '@element-plus/icons-vue'
import { createApp } from 'vue'
import { createPinia } from 'pinia'
import piniaPluginPersistedstate from 'pinia-plugin-persistedstate'
import { VueMasonryPlugin } from 'vue-masonry'
import ElementPlus from 'element-plus'
import zhCn from 'element-plus/es/locale/lang/zh-cn'
import App from './App.vue'
import router from './router'
import SvgIcon from '@/components/SvgIcon/index.vue'
import uploader from 'vue-simple-uploader'
import 'vue-simple-uploader/dist/style.css'
import { useUserStore } from '@/stores/user'
import { useThemeStore } from '@/stores/theme'

const app = createApp(App)
app.use(ElementPlus, {
    size: 'large',
    locale: zhCn
})
const pinia = createPinia()
pinia.use(piniaPluginPersistedstate)

for (const [key, component] of Object.entries(ElementPlusIconsVue)) {
    app.component(key, component)
}

app.use(uploader)
app.use(pinia)
app.use(router)
app.use(VueMasonryPlugin)

app.component('SvgIcon', SvgIcon)

app.mount('#app')

// 应用启动后检查用户登录状态，如果已登录则初始化WebSocket
const userStore = useUserStore()
const themeStore = useThemeStore()

// 初始化主题
themeStore.initTheme()

if (userStore.isLogin) {
    userStore.initWebSocketConnection()
}
