interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[] | any
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number
    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean
    [key: string]: any
}

export function useTableOptionConfig() {
    const fixedOptionList: IOption[] = [
        {
            title: '标题',
            prop: 'subject',
            type: 'input',
            value: '',
            span: 8
        },
        {
            title: '消息状态',
            prop: 'receiveTime',
            type: 'select',
            clearable: false,
            options: [
                { name: '未读', value: '1' },
                { name: '已读', value: '0' }
            ],
            value: '1',
            defaultValue: '1',
            span: 3
        }
    ]
    const columnsList: COption[] = [
        {
            title: '标题',
            prop: 'subject',
            minWidth: 200
        },
        {
            title: '消息状态',
            prop: 'read',
            render: true,
            minWidth: 100
        },
        {
            title: '发信人',
            prop: 'owner',
            minWidth: 100
        },
        {
            title: '发送时间',
            prop: 'createTime',
            render: true,
            minWidth: 100
        },
        {
            title: '查看时间',
            prop: 'receiveTime',
            render: true,
            minWidth: 100
        }
    ]
    return {
        fixedOptionList,
        columnsList
    }
}
