import request from '@/requset/axios'

// 系统信息查询
export const sysInfoQuery = (data: string) => {
    return new Promise((resolve, reject) => {
        request
            .get('/uc/tenantManage/v1/getTenantByCode?code=' + data)
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

// 系统字典
export const sysDictQuery = () => {
    return new Promise((resolve, reject) => {
        request
            .post('/sys/sysDictionary/v1/queryAllDictItems')
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}
