/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.examine.manager.ExamNoticeManager;
import com.artfess.examine.model.ExamNotice;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u901a\u77e5\u516c\u544a"})
@RequestMapping(value={"/exam/notice/"})
@ApiGroup(group={"group_biz"})
public class ExamNoticeController
extends BaseController<ExamNoticeManager, ExamNotice> {
    private static final Logger log = LoggerFactory.getLogger(ExamNoticeController.class);

    @PostMapping(value={"/modifyTopStatus"})
    @ApiOperation(value="\u516c\u544a\u7f6e\u9876")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.UPDATE, description="\u516c\u544a\u7f6e\u9876")
    public CommonResult<String> modifyTopStatus(@ApiParam(name="model", value="\u516c\u544a\u7f6e\u9876") @RequestBody ExamNotice entity) {
        log.info("\u516c\u544a\u7f6e\u9876\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        boolean b = ((ExamNoticeManager)this.baseService).modifyTopStatus(entity);
        log.info("\u516c\u544a\u7f6e\u9876\u54cd\u5e94\u7ed3\u679c:{}", (Object)b);
        if (!b) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/modifyStatus"})
    @ApiOperation(value="\u4fee\u6539\u516c\u544a\u72b6\u6001")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.UPDATE, description="\u4fee\u6539\u516c\u544a\u72b6\u6001")
    public CommonResult<String> modifyEnabled(@ApiParam(name="model", value="\u516c\u544a") @RequestBody ExamNotice entity) {
        log.info("\u4fee\u6539\u516c\u544a\u72b6\u6001\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        boolean b = ((ExamNoticeManager)this.baseService).modifyStatus(entity);
        log.info("\u4fee\u6539\u516c\u544a\u72b6\u6001\u54cd\u5e94\u7ed3\u679c:{}", (Object)b);
        if (!b) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/findByPage"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u516c\u544a\u67e5\u8be2")
    public PageList<ExamNotice> findByPage(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamNotice> queryFilter) {
        queryFilter.addFilter("endTime", (Object)LocalDateTime.now(), QueryOP.GREAT_EQUAL, FieldRelation.AND);
        FieldSort sort = new FieldSort();
        sort.setProperty("topStatus");
        sort.setDirection(Direction.DESC);
        queryFilter.getSorter().add(sort);
        return ((ExamNoticeManager)this.baseService).query(queryFilter);
    }
}

