package com.artfess.sysConfig.persistence.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.sysConfig.persistence.dao.PortalAppParamDao;
import com.artfess.sysConfig.persistence.manager.PortalAppParamManager;
import com.artfess.sysConfig.persistence.model.PortalAppParam;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 应用参数 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author zst
 * @since 2020-10-13
 */
@Service
public class PortalAppParamManagerImpl extends BaseManagerImpl<PortalAppParamDao, PortalAppParam> implements PortalAppParamManager {

    @Override
    public boolean existsByAppId(String appId) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq("APP_ID_",appId);
        List list = list(qw);
        if(BeanUtils.isEmpty(list)){
            return false;
        }else{
            return true;
        }
    }

    @Override
    public List<PortalAppParam> getbyAppId(String appId) {
        QueryFilter<PortalAppParam> queryFilter = QueryFilter.build();
        queryFilter.addFilter("APP_ID_",appId, QueryOP.EQUAL, FieldRelation.AND);
        PageList<PortalAppParam> pageList = this.query(queryFilter);
        return pageList.getRows();
    }
}
