package com.artfess.bo.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

/**
 * bo定义xml包装类
 * <pre>
 * 此类用于bo的导入导出
 * </pre>
 *
 * @author heyifan
 * @company 阿特菲斯信息技术有限公司
 * @email heyf@jee-soft.cn
 * @date 2018年4月12日
 */
@XmlRootElement(name = "bodefs")
@XmlAccessorType(XmlAccessType.FIELD)
public class BoDefXml {
    @XmlElement(name = "bodef", type = BoDef.class)
    private List<BoDef> defList = new ArrayList<BoDef>();

    public List<BoDef> getDefList() {
        return defList;
    }

    public void setDefList(List<BoDef> defList) {
        this.defList = defList;
    }

    /**
     * 添加bo定义列表。
     *
     * @param def
     */
    public void addBodef(BoDef def) {
        this.defList.add(def);
    }
}
