/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.manager.impl;

import com.artfess.base.entity.BaseTreeModel;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.manager.QueryFilterHelper;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.helper.StringUtil;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class BaseManagerImpl<M extends BaseMapper<T>, T extends Model<T>>
extends ServiceImpl<M, T>
implements BaseManager<T>,
QueryFilterHelper<T> {
    @Override
    public T get(Serializable id) {
        return (T)((Model)this.getById(id));
    }

    @Override
    public void create(T t) {
        this.save(t);
    }

    @Override
    public void update(T t) {
        this.updateById(t);
    }

    @Override
    public void remove(Serializable id) {
        this.removeById(id);
    }

    @Override
    public void removeByIds(String ... ids) {
        this.removeByIds(Arrays.asList(ids));
    }

    @Override
    @Transactional(readOnly=true)
    public PageList<T> query(QueryFilter<T> queryFilter) {
        BaseMapper m = super.getBaseMapper();
        PageBean pageBean = queryFilter.getPageBean();
        Class currentModelClass = this.currentModelClass();
        IPage result = m.selectPage(this.convert2IPage(pageBean), this.convert2Wrapper(queryFilter, currentModelClass));
        return new PageList(result);
    }

    @Override
    public PageList<T> page(PageBean pageBean) {
        IPage result = this.page(this.convert2IPage(pageBean));
        return new PageList(result);
    }

    @Override
    public List<T> getAll() {
        return this.list();
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> queryNoPage(QueryFilter<T> queryFilter) {
        BaseMapper m = super.getBaseMapper();
        Class currentModelClass = this.currentModelClass();
        return m.selectList(this.convert2Wrapper(queryFilter, currentModelClass));
    }

    @Override
    @Transactional
    public void updateSequence(Map<String, Integer> params) {
        Assert.notEmpty(params, (String)"\u53c2\u6570params\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        BaseMapper m = super.getBaseMapper();
        for (String key : params.keySet()) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.set((Object)"SN_", (Object)params.get(key))).eq((Object)"ID_", (Object)key);
            m.update(null, (Wrapper)updateWrapper);
        }
    }

    @Override
    public Integer getNextSequence(Map<String, Object> criteriaMap) {
        List resultList;
        BaseMapper m = super.getBaseMapper();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"COALESCE(max(SN_),0) sn"});
        if (criteriaMap != null && !criteriaMap.isEmpty()) {
            queryWrapper.allEq(criteriaMap);
        }
        if ((resultList = m.selectMaps((Wrapper)queryWrapper)) != null && resultList.size() > 0) {
            int n;
            Map resultMap = (Map)resultList.get(0);
            Integer result = Integer.parseInt(resultMap.get("sn").toString());
            if (result == null) {
                n = 1;
            } else {
                result = result + 1;
                n = result;
            }
            return n;
        }
        return 1;
    }

    @Override
    public Integer getNextSequenceByParentId(String parentId) {
        HashMap<String, Object> criteriaMap = new HashMap<String, Object>();
        criteriaMap.put("parent_id_", parentId);
        return this.getNextSequence(criteriaMap);
    }

    public List<T> findDuplicateEntities(String id, String parentId, String code, String name) {
        Assert.hasText((String)code, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Assert.hasText((String)name, (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        BaseMapper m = super.getBaseMapper();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.ne((Object)"id_", (Object)(StringUtil.isBlank((String)id) ? "@" : id))).eq((Object)"parent_Id_", (Object)parentId)).and(i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.eq((Object)"upper(code_) ", (Object)code.toUpperCase())).or()).eq((Object)"upper(name_)", (Object)name.toUpperCase());
        });
        return m.selectList((Wrapper)queryWrapper);
    }

    @Override
    @Transactional
    public String insertTree(BaseTreeModel entity) {
        return this.saveTree(entity, true);
    }

    @Transactional
    public String saveTree(BaseTreeModel entity, boolean useDefaultCheck) {
        BaseMapper m = super.getBaseMapper();
        if (useDefaultCheck) {
            List<T> duplicateEntities = this.findDuplicateEntities(entity.getId(), entity.getParentId(), entity.getCode(), entity.getName());
            BaseTreeModel other = null;
            if (duplicateEntities.size() > 0) {
                other = (BaseTreeModel)((Object)duplicateEntities.get(0));
            }
            entity.checkConstraints(other);
        }
        if (entity.isNew()) {
            entity.setHasChildren(0);
            m.insert((Object)entity);
        }
        BaseTreeModel parent = (BaseTreeModel)((Object)this.baseMapper.selectById((Serializable)((Object)entity.getParentId())));
        entity.buildFullIdAndName(parent);
        if (entity.getSn() == null) {
            entity.setSn(parent == null ? 1 : parent.getHasChildren() + 1);
        }
        m.updateById((Object)entity);
        if (parent != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"parent_Id_", (Object)entity.getParentId());
            Integer childrenCount = this.baseMapper.selectCount((Wrapper)queryWrapper);
            parent.setHasChildren(childrenCount);
            m.updateById((Object)parent);
        }
        return entity.getId();
    }

    @Override
    @Transactional
    public String saveTreeAndId(BaseTreeModel entity) {
        BaseMapper m = super.getBaseMapper();
        entity.setId(entity.getCode());
        entity.setHasChildren(0);
        m.insert((Object)entity);
        BaseTreeModel parent = (BaseTreeModel)((Object)this.baseMapper.selectById((Serializable)((Object)entity.getParentId())));
        entity.buildFullIdAndName(parent);
        if (entity.getSn() == null) {
            entity.setSn(parent == null ? 1 : parent.getHasChildren() + 1);
        }
        m.updateById((Object)entity);
        if (parent != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"parent_Id_", (Object)entity.getParentId());
            Integer childrenCount = this.baseMapper.selectCount((Wrapper)queryWrapper);
            parent.setHasChildren(childrenCount);
            m.updateById((Object)parent);
        }
        return entity.getId();
    }

    @Override
    @Transactional
    public String updateTree(BaseTreeModel entity, String oldName) {
        BaseMapper m = super.getBaseMapper();
        m.updateById((Object)entity);
        BaseTreeModel treeEntity = (BaseTreeModel)((Object)m.selectById((Serializable)((Object)entity.getId())));
        return this.updateTree(treeEntity, oldName, true);
    }

    @Transactional
    public String updateTree(BaseTreeModel entity, String oldName, boolean useDefaultCheck) {
        Assert.notNull((Object)((Object)entity), (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        boolean updatedName = entity.isUpdateName(oldName);
        String oldFullName = entity.getFullName();
        String id = this.saveTree(entity, useDefaultCheck);
        if (updatedName) {
            this.updateChildrenFullName(entity.getFullId(), oldFullName, entity.getFullName());
        }
        return id;
    }

    @Transactional
    public void updateChildrenFullName(String fullId, String oldFullName, String newFullName) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.setSql("full_Name_ = concat('" + newFullName + "', substring(full_Name_,char_length('" + oldFullName + "') + 1,char_length(full_Name_)))")).likeRight((Object)"full_Id_", (Object)fullId);
        this.baseMapper.update(null, (Wrapper)updateWrapper);
    }

    public boolean checkSameField(String id, String fieldName, String fieldValue) {
        Assert.hasText((String)fieldName, (String)"\u8981\u6bd4\u8f83\u7684\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Assert.hasText((String)fieldValue, (String)"\u5b57\u6bb5\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)fieldName, (Object)fieldValue);
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)id), (Object)"ID_", (Object)id);
        int num = this.baseMapper.selectCount((Wrapper)queryWrapper);
        return num == 0;
    }
}

