/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.model.BoDataModifyRecord;
import com.artfess.bpm.persistence.dao.BoDataModifyRecordDao;
import com.artfess.bpm.persistence.manager.BoDataModifyRecordManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="boDataModifyRecordManager")
public class BoDataModifyRecordManagerImpl
extends BaseManagerImpl<BoDataModifyRecordDao, BoDataModifyRecord>
implements BoDataModifyRecordManager {
    @Resource
    BoDataModifyRecordDao boDataModifyRecordDao;

    @Override
    public void handleBoDateModify(Map<String, Object> params) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        String modifyRes = "";
        String refId = "";
        JsonNode boResult = JsonUtil.toJsonNode((Object)params.get("boResult"));
        for (JsonNode objectNode : boResult) {
            if (!objectNode.hasNonNull("modifyDetail") || !StringUtil.isNotEmpty((String)objectNode.get("modifyDetail").asText())) continue;
            modifyRes = objectNode.get("modifyDetail").asText();
            refId = objectNode.get("pk").asText();
            break;
        }
        if (StringUtil.isEmpty((String)modifyRes)) {
            return;
        }
        BoDataModifyRecord record = new BoDataModifyRecord();
        if (StringUtil.isNotEmpty((String)refId)) {
            record.setRefId(refId);
        }
        if (BeanUtils.isNotEmpty((Object)params.get("data"))) {
            record.setData(JsonUtil.toJson((Object)params.get("data")));
        }
        record.setUserId(currentUser.getUserId());
        record.setUserName(currentUser.getFullname());
        record.setDetail(modifyRes);
        record.setModifyTime(LocalDateTime.now());
        this.create((Model)record);
    }

    @Override
    public List<BoDataModifyRecord> getListByRefId(String refId) {
        return this.boDataModifyRecordDao.getListByRefId(refId);
    }
}

