/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.businessdata.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.businessdata.manager.CompanyManager;
import com.artfess.yhxt.businessdata.model.Company;
import com.artfess.yhxt.businessdata.vo.CompanyVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/Company/v1/"})
@Api(tags={"\u517b\u62a4\u5355\u4f4d\u7ba1\u7406"})
@ApiGroup(group={"group_biz"})
public class CompanyController
extends BaseController<CompanyManager, Company> {
    @PostMapping(value={"/list"})
    @ApiOperation(value="\u517b\u62a4\u5355\u4f4d\u7ba1\u7406\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u517b\u62a4\u5355\u4f4d\u7ba1\u7406\u5217\u8868")
    public PageList<Company> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Company> queryFilter) throws Exception {
        return ((CompanyManager)this.baseService).query(queryFilter);
    }

    @GetMapping(value={"/get/{id}"})
    @ApiOperation(value="\u517b\u62a4\u5355\u4f4d\u7ba1\u7406\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u517b\u62a4\u5355\u4f4d\u7ba1\u7406\u6570\u636e\u8be6\u60c5")
    public Company get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return (Company)((CompanyManager)this.baseService).get((Serializable)((Object)id));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u517b\u62a4\u5355\u4f4d\u7ba1\u7406\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u517b\u62a4\u5355\u4f4d\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="Company", value="\u517b\u62a4\u5355\u4f4d\u7ba1\u7406\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody Company company) throws Exception {
        String msg = "\u6dfb\u52a0\u517b\u62a4\u5355\u4f4d\u7ba1\u7406\u6210\u529f";
        if (StringUtil.isEmpty((String)String.valueOf(company.getId()))) {
            ((CompanyManager)this.baseService).saveCompany(company);
        } else {
            ((CompanyManager)this.baseService).updateCompany(company);
            msg = "\u66f4\u65b0\u517b\u62a4\u5355\u4f4d\u7ba1\u7406\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove/{id}"})
    @ApiOperation(value="\u5220\u9664\u517b\u62a4\u5355\u4f4d\u7ba1\u7406\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u517b\u62a4\u5355\u4f4d\u7ba1\u7406\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e1a\u52a1\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        ((CompanyManager)this.baseService).remove((Serializable)((Object)id));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u517b\u62a4\u5355\u4f4d\u7ba1\u7406\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u517b\u62a4\u5355\u4f4d\u7ba1\u7406\u8bb0\u5f55")
    public CommonResult<String> removes(@ApiParam(name="ids", value="\u591a\u4e2a\u4e3b\u952e\u4e4b\u95f4\u7528\u9017\u53f7\u5206\u9694", required=true) @RequestParam String ids, @RequestParam String code) throws Exception {
        ((CompanyManager)this.baseService).removeCompanyByIds(Arrays.asList(ids), code);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/getList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0d\u5206\u9875\u67e5\u8be2\u517b\u62a4\u5355\u4f4d\u660e\u7ec6\u4fe1\u606f", httpMethod="POST")
    public PageList<Company> getList(@ApiParam(name="queryFilter", value="\u4e0d\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<Company> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<Company> road = ((CompanyManager)this.baseService).queryCompany(queryFilter);
        return road;
    }

    @RequestMapping(value={"/getJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u517b\u62a4\u5355\u4f4d\u660e\u7ec6\u4fe1\u606f", httpMethod="POST")
    public PageList<Company> getJson(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<Company> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        PageList<Company> pageList = ((CompanyManager)this.baseService).queryCompany(queryFilter);
        return pageList;
    }

    @RequestMapping(value={"/getTree/{demId}"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u517b\u62a4\u5355\u4f4d", httpMethod="POST")
    public List<CompanyVo> getTree(@ApiParam(name="demId", value="\u7ef4\u5ea6ID", required=true) @PathVariable String demId, @ApiParam(name="grades", value="\u9700\u8981\u7981\u7528\u7ea7\u522b\u7f16\u7801\u96c6\u5408", required=false) @RequestBody List<String> grades) throws Exception {
        return ((CompanyManager)this.baseService).getTree(demId, grades);
    }

    @RequestMapping(value={"/getTree/company/{demId}"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u516c\u53f8", httpMethod="GET")
    public List<CompanyVo> getTreeCompany(@ApiParam(name="demId", value="\u7ef4\u5ea6ID", required=true) @PathVariable String demId) throws Exception {
        return ((CompanyManager)this.baseService).getTreeCompany(demId);
    }

    @RequestMapping(value={"/getTree/Newcompany/{demId}"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u516c\u53f8\u7edf\u8ba1\u62a5\u8868\u6a21\u5757", httpMethod="GET")
    public List<CompanyVo> getTreeNewCompany(@ApiParam(name="demId", value="\u7ef4\u5ea6ID", required=true) @PathVariable String demId) throws Exception {
        return ((CompanyManager)this.baseService).getTreeNewCompany(demId);
    }

    @RequestMapping(value={"/getCompany"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u767b\u5f55\u4eba\u67e5\u8be2\u516c\u53f8", httpMethod="POST")
    public List<Org> getCompany(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter queryFilter) throws Exception {
        return ((CompanyManager)this.baseService).getCompany(queryFilter);
    }
}

