/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.ext.identity;

import com.artfess.activiti.ext.identity.INodeDef;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.BaseActionCmd;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.exception.ProcessDefException;
import com.artfess.bpm.api.helper.identity.UserQueryPluginHelper;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.def.BpmDefinition;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.NodeProperties;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.CallActivityNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmDefinitionService;
import com.artfess.bpm.api.service.BpmSignDataService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActUserService {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    UserQueryPluginHelper userQueryPluginHelper;
    @Resource
    BpmSignDataService bpmSignDataService;
    private static final Logger logger = LoggerFactory.getLogger(ActUserService.class);

    public List<BpmIdentity> getExtSubProcessMultipleUser(final ActivityExecution execution) throws Exception {
        List<BpmIdentity> list = this.getCommonUser(execution, new INodeDef(){

            @Override
            public BpmNodeDef getNodeDef(String bpmnDefId, String nodeId) throws Exception {
                BpmNodeDef bpmNodeDef = ActUserService.this.bpmDefinitionService.getBpmNodeDef(bpmnDefId, nodeId);
                CallActivityNodeDef callNodeDef = (CallActivityNodeDef)bpmNodeDef;
                String flowKey = callNodeDef.getFlowKey();
                BpmDefinition bpmDef = ActUserService.this.bpmDefinitionService.getBpmDefinitionByDefKey(flowKey, false);
                if (BeanUtils.isEmpty((Object)bpmDef)) {
                    String str = execution.getCurrentActivityName() + "\u672a\u83b7\u53d6\u5230\u5916\u90e8\u5b50\u6d41\u7a0b\u8282\u70b9\u5b9a\u4e49!";
                    logger.debug(str);
                    throw new ProcessDefException(str);
                }
                BpmProcessDef subProcessDef = ActUserService.this.bpmDefinitionAccessor.getBpmProcessDef(bpmDef.getDefId());
                List bpmNodeDefList = subProcessDef.getStartNodes();
                if (bpmNodeDefList.size() > 1) {
                    String str = execution.getCurrentActivityName() + "\u5916\u90e8\u591a\u5b9e\u4f8b\u5b50\u6d41\u7a0b\u53d1\u8d77\u8282\u70b9\u540e\u53ea\u80fd\u6709\u4e00\u4e2a\u540e\u7eed\u8282\u70b9!";
                    logger.debug(str);
                    throw new ProcessDefException(str);
                }
                BpmNodeDef firstNode = (BpmNodeDef)bpmNodeDefList.get(0);
                return firstNode;
            }
        }, 3);
        return list;
    }

    public List<BpmIdentity> getSubProcessUser(final ActivityExecution execution) throws Exception {
        List<BpmIdentity> list = this.getCommonUser(execution, new INodeDef(){

            @Override
            public BpmNodeDef getNodeDef(String bpmnDefId, String nodeId) throws Exception {
                BpmNodeDef bpmNodeDef = ActUserService.this.bpmDefinitionService.getBpmNodeDef(bpmnDefId, nodeId);
                SubProcessNodeDef subProcessNodeDef = (SubProcessNodeDef)bpmNodeDef;
                BpmProcessDef subProcessDef = subProcessNodeDef.getChildBpmProcessDef();
                List bpmNodeDefList = subProcessDef.getStartNodes();
                if (bpmNodeDefList.size() > 1) {
                    String str = execution.getCurrentActivityName() + "\u5185\u90e8\u591a\u5b9e\u4f8b\u5b50\u6d41\u7a0b\u53d1\u8d77\u8282\u70b9\u540e\u53ea\u80fd\u6709\u4e00\u4e2a\u540e\u7eed\u8282\u70b9!";
                    logger.debug(str);
                    throw new ProcessDefException(str);
                }
                BpmNodeDef firstNode = (BpmNodeDef)bpmNodeDefList.get(0);
                return firstNode;
            }
        }, 2);
        return list;
    }

    public List<BpmIdentity> getSignUser(ActivityExecution execution) throws Exception {
        List<BpmIdentity> list = this.getCommonUser(execution, new INodeDef(){

            @Override
            public BpmNodeDef getNodeDef(String bpmnDefId, String nodeId) throws Exception {
                String defId = ActUserService.this.bpmDefinitionService.getDefIdByBpmnDefId(bpmnDefId);
                BpmNodeDef bpmNodeDef = ActUserService.this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
                return bpmNodeDef;
            }
        }, 1);
        return list;
    }

    private List<BpmIdentity> getCommonUser(ActivityExecution execution, INodeDef nodeDef, Integer type) throws Exception {
        NodeProperties nodeProperties;
        String backUserMode;
        String actDefId = execution.getProcessDefinitionId();
        String nodeId = execution.getCurrentActivityId();
        String nodeName = execution.getCurrentActivityName();
        List bpmIdentities = new ArrayList();
        String multiInstance = (String)execution.getActivity().getProperty("multiInstance");
        String varName = "signUsers_" + nodeId;
        BaseActionCmd actionCmd = (BaseActionCmd)ContextThreadUtil.getActionCmd();
        if ("sequential".equals(multiInstance) && BeanUtils.isNotEmpty(bpmIdentities = (List)execution.getVariable(varName))) {
            return bpmIdentities;
        }
        BpmNodeDef bpmNodeDef = nodeDef.getNodeDef(actDefId, nodeId);
        String currentNodeId = bpmNodeDef.getNodeId();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        String actionName = cmd.getActionName();
        if ("reject".equals(actionName) && cmd.getTransitVars("IsDoneUnused") == null && bpmNodeDef instanceof SignNodeDef && (StringUtil.isEmpty((String)(backUserMode = (nodeProperties = bpmNodeDef.getLocalProperties()).getBackUserMode())) || backUserMode.equals("history")) && type == 1 && BeanUtils.isNotEmpty(bpmIdentities = this.bpmSignDataService.getHistoryAuditor(execution.getParentId(), nodeId))) {
            this.saveSequnceExecutorVar(multiInstance, execution, bpmIdentities);
            actionCmd.setBpmIdentity(currentNodeId, bpmIdentities);
            return bpmIdentities;
        }
        Map identityMap = actionCmd.getBpmIdentities();
        bpmIdentities = (List)identityMap.get(currentNodeId);
        if (BeanUtils.isNotEmpty(bpmIdentities)) {
            this.saveSequnceExecutorVar(multiInstance, execution, bpmIdentities);
            return bpmIdentities;
        }
        Map nodeUsers = (Map)actionCmd.getTransitVars("bpm_node_users_");
        if (actionCmd.getTransitVars("bpm_next_node_users_") != null) {
            bpmIdentities = (List)actionCmd.getTransitVars("bpm_next_node_users_");
            actionCmd.setBpmIdentity(currentNodeId, bpmIdentities);
        }
        if (nodeUsers != null && nodeUsers.containsKey(nodeId)) {
            bpmIdentities = (List)nodeUsers.get(nodeId);
            actionCmd.setBpmIdentity(currentNodeId, bpmIdentities);
        }
        if (BeanUtils.isNotEmpty(bpmIdentities)) {
            this.saveSequnceExecutorVar(multiInstance, execution, bpmIdentities);
            actionCmd.setBpmIdentity(currentNodeId, bpmIdentities);
            return bpmIdentities;
        }
        List bpmPluginContexts = bpmNodeDef.getBpmPluginContexts();
        bpmIdentities = this.userQueryPluginHelper.query(bpmPluginContexts, execution.getVariables(), "user");
        if (BeanUtils.isNotEmpty(bpmIdentities)) {
            this.saveSequnceExecutorVar(multiInstance, execution, bpmIdentities);
            actionCmd.setBpmIdentity(currentNodeId, bpmIdentities);
        }
        if (BeanUtils.isEmpty(bpmIdentities)) {
            String str = nodeName + "\u591a\u5b9e\u4f8b\u8282\u70b9\u4e0b\u6ca1\u6709\u914d\u7f6e\u6267\u884c\u4eba!";
            logger.debug(str);
            throw new RuntimeException(str);
        }
        return bpmIdentities;
    }

    private void saveSequnceExecutorVar(String multiInstance, ActivityExecution execution, List<BpmIdentity> userIds) {
        String nodeId = execution.getActivity().getId();
        if (!"sequential".equals(multiInstance)) {
            return;
        }
        String varName = "signUsers_" + nodeId;
        execution.setVariable(varName, userIds);
    }
}

