package com.artfess.application.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 消息分类实体对象
 *
 * @company 广州宏天软件股份有限公司
 * @author hugh
 * @email zxh@jee-soft.cn
 * @date 2014-11-17 17:49:50
 */
@ApiModel(description="消息分类实体对象")
@TableName("portal_sys_msg_type")
public class MessageType extends AutoFillModel<MessageType> {
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(name="id", notes="主键")
	@TableId("id_")
	protected String id;

	@ApiModelProperty(name="name", notes="分类名称")
	@TableField("name_")
	protected String name;

	@ApiModelProperty(name="code", notes="分类编码")
	@TableField("code_")
	protected String code;

	@ApiModelProperty(name="sn", notes="排序号")
	@TableField("sn_")
	protected Short sn;

	/**
	 * 返回主键
	 */
	public String getId() {
		return id;
	}
	/**
	 * 设置主键
	 *@param id 主键
	 */
	public void setId(String id) {
		this.id = id;
	}
	/**
	 * 返回分类名称
	 */
	public String getName() {
		return name;
	}
	/**
	 * 设置分类名称
	 *@param name 分类名称
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * 返回分类编码
	 */
	public String getCode() {
		return code;
	}

	/**
	 * 设置分类编码
	 *@param code 分类编码
	 */
	public void setCode(String code) {
		this.code = code;
	}
	/**
	 * 返回排序号
	 */
	public Short getSn() {
		return sn;
	}
	/**
	 * 设置排序号
	 *@param sn 排序号
	 */
	public void setSn(Short sn) {
		this.sn = sn;
	}

	/**
	 * 返回租户ID
	 */



	@Override
	public String toString() {
		return "MessageType{" +
				"id='" + id + '\'' +
				", name='" + name + '\'' +
				", code='" + code + '\'' +
				", sn=" + sn +
				'}';
	}
}
