import request from '@/requset/axios'

interface ApiResponse {
    state?: boolean
    message?: string
    value?: any
}
// 分片初始化
export function initFile(data: object): Promise<ApiResponse> {
    return new Promise((resolve, reject) => {
        request
            .post(`/file/v1/init`, data)
            .then((res) => resolve(res.data || {}))
            .catch((err) => reject(err))
    })
}

// 分片合并
export function completeUpload(uploadId: string | number): Promise<ApiResponse> {
    return new Promise((resolve, reject) => {
        request
            .post(`/file/v1/completeUpload`, { uploadId })
            .then((res) => resolve(res.data || {}))
            .catch((err) => reject(err))
    })
}
