/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.poi.editor;

import com.artfess.poi.ExcelContext;
import com.artfess.poi.editor.AbstractEditor;
import com.artfess.poi.editor.IPrintSetup;
import com.artfess.poi.editor.listener.CellValueListener;
import com.artfess.poi.util.ExcelUtil;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Sheet;

public class SheetEditor
extends AbstractEditor {
    private HSSFSheet sheet;
    private int sheetIndex;

    public SheetEditor(HSSFSheet sheet, ExcelContext context) {
        super(context);
        this.sheet = sheet;
        this.sheetIndex = this.workBook.getSheetIndex((Sheet)this.sheet);
    }

    public SheetEditor header(String left, String center, String right) {
        HSSFHeader header = this.sheet.getHeader();
        header.setLeft(left == null ? "" : left);
        header.setCenter(center == null ? "" : center);
        header.setRight(right == null ? "" : right);
        return this;
    }

    public SheetEditor footer(String left, String center, String right) {
        HSSFFooter footer = this.sheet.getFooter();
        footer.setLeft(left == null ? "" : left);
        footer.setCenter(center == null ? "" : center);
        footer.setRight(right == null ? "" : right);
        return this;
    }

    public SheetEditor sheetName(String name) {
        this.sheetName(name, false);
        return this;
    }

    public SheetEditor sheetName(String name, boolean autoRename) {
        if (autoRename) {
            String newName = new String(name);
            HSSFSheet sheet = this.workBook.getSheet(name);
            while (sheet != null) {
                newName = newName + "_";
                sheet = this.workBook.getSheet(newName);
            }
            this.workBook.setSheetName(this.sheetIndex, newName);
        } else {
            this.workBook.setSheetName(this.sheetIndex, name);
        }
        return this;
    }

    public SheetEditor active() {
        this.workBook.setActiveSheet(this.sheetIndex);
        return this;
    }

    public SheetEditor freeze(int row, int col) {
        if (row < 0) {
            row = 0;
        }
        if (col < 0) {
            col = 0;
        }
        this.sheet.createFreezePane(col, row, col, row);
        return this;
    }

    public int getLastRowNum() {
        return ExcelUtil.getLastRowNum(this.sheet);
    }

    public SheetEditor displayGridlines(boolean show) {
        this.sheet.setDisplayGridlines(show);
        return this;
    }

    public SheetEditor printGridlines(boolean newPrintGridlines) {
        this.sheet.setPrintGridlines(newPrintGridlines);
        return this;
    }

    public SheetEditor fitToPage(boolean isFit) {
        this.sheet.setFitToPage(isFit);
        return this;
    }

    public SheetEditor horizontallyCenter(boolean isCenter) {
        this.sheet.setHorizontallyCenter(isCenter);
        return this;
    }

    public SheetEditor password(String pw) {
        this.sheet.protectSheet(pw);
        return this;
    }

    public SheetEditor printSetup(IPrintSetup printSetup) {
        printSetup.setup(this.sheet.getPrintSetup());
        return this;
    }

    public SheetEditor autobreaks(boolean b) {
        this.sheet.setAutobreaks(b);
        return this;
    }

    public SheetEditor addCellValueListener(CellValueListener listener) {
        this.ctx.getListenerList(this.sheetIndex).add(listener);
        return this;
    }

    public SheetEditor removeCellValueListener(CellValueListener listener) {
        this.ctx.getListenerList(this.sheetIndex).remove(listener);
        return this;
    }

    public HSSFSheet toHSSFSheet() {
        return this.sheet;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public SheetEditor groupRow(int fromRow, int toRow) {
        this.sheet.groupRow(fromRow, toRow);
        return this;
    }

    public SheetEditor groupColumn(int fromColumn, int toColumn) {
        this.sheet.groupColumn(fromColumn, toColumn);
        return this;
    }
}

