/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.bpmModel.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.persistence.manager.CurrentUserService;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.service.IUserGroupService;
import com.artfess.workflow.bpmModel.dao.BpmOftenFlowDao;
import com.artfess.workflow.bpmModel.dao.BpmOftenFlowUserDao;
import com.artfess.workflow.bpmModel.manager.BpmOftenFlowManager;
import com.artfess.workflow.bpmModel.model.BpmOftenFlow;
import com.artfess.workflow.bpmModel.model.BpmOftenFlowUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmCommonDefManager")
public class BpmOftenFlowManagerImpl
extends BaseManagerImpl<BpmOftenFlowDao, BpmOftenFlow>
implements BpmOftenFlowManager {
    @Resource
    IUserGroupService defaultUserGroupService;
    @Resource
    BpmOftenFlowUserDao bpmOftenFlowUserDao;
    @Resource(name="bpmCurrentUserService")
    private CurrentUserService currentUserService;

    @Override
    @Transactional
    public void removeByUserIdAndDefKeys(String userId, List<String> defkeys) {
        ((BpmOftenFlowDao)this.baseMapper).removeByUserIdAndDefKeys(userId, defkeys);
    }

    @Override
    @Transactional
    public CommonResult<String> saveOrUpdateCommonFlow(Map<String, Object> map) throws Exception {
        List defkeysAry = (List)map.get("defkeys");
        String type = map.get("type").toString();
        ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((Object)map.get("calOwnerNameJson"));
        String msg = "\u6dfb\u52a0\u5e38\u7528\u6d41\u7a0b\u6210\u529f";
        if (BeanUtils.isNotEmpty((Object)defkeysAry)) {
            for (String defKey : defkeysAry) {
                BpmOftenFlow bpmOftenFlow = ((BpmOftenFlowDao)this.baseMapper).getBpmOftenFlow(defKey);
                if ("add".equals(type)) {
                    if (BeanUtils.isNotEmpty((Object)((Object)bpmOftenFlow))) {
                        return new CommonResult(false, "\u6d41\u7a0bkey\uff1a" + defKey + "\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                    }
                    if (BeanUtils.isEmpty((Object)arrayNode)) {
                        return new CommonResult(false, "\u5e38\u7528\u6388\u6743\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u6dfb\u52a0");
                    }
                    String id = UniqueIdUtil.getSuid();
                    BpmOftenFlow entity = new BpmOftenFlow();
                    entity.setId(id);
                    entity.setDefKey(defKey);
                    ((BpmOftenFlowDao)this.baseMapper).insert((Object)entity);
                    for (JsonNode jsonNode : arrayNode) {
                        this.saveBpmOftenFlowUser(jsonNode, id);
                    }
                    continue;
                }
                if (!"edit".equals(type)) continue;
                if (BeanUtils.isEmpty((Object)((Object)bpmOftenFlow))) {
                    return new CommonResult(false, "\u901a\u8fc7\u6d41\u7a0bkey\uff1a" + defKey + "\u67e5\u8be2\u4e0d\u5230\u5e38\u7528\u6d41\u7a0b");
                }
                if (BeanUtils.isEmpty((Object)arrayNode)) {
                    return new CommonResult(false, "\u5e38\u7528\u6388\u6743\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u6dfb\u52a0");
                }
                this.bpmOftenFlowUserDao.removeByOftenFlowId(bpmOftenFlow.getId());
                for (JsonNode jsonNode : arrayNode) {
                    this.saveBpmOftenFlowUser(jsonNode, bpmOftenFlow.getId());
                }
            }
        }
        if ("edit".equals(type)) {
            msg = "\u4fee\u6539\u5e38\u7528\u6d41\u7a0b\u6210\u529f";
        }
        return new CommonResult(true, msg);
    }

    private void saveBpmOftenFlowUser(JsonNode jsonNode, String id) {
        String rightType = jsonNode.get("type").asText();
        if ("everyone".equals(rightType)) {
            BpmOftenFlowUser bpmOftenFlowUser = new BpmOftenFlowUser();
            bpmOftenFlowUser.setId(UniqueIdUtil.getSuid());
            bpmOftenFlowUser.setOftenFlowId(id);
            bpmOftenFlowUser.setRightType(rightType);
            this.bpmOftenFlowUserDao.insert((Object)bpmOftenFlowUser);
        } else {
            String[] ids = jsonNode.get("id").asText().split(",");
            String[] names = jsonNode.get("name").asText().split(",");
            for (int i = 0; i < ids.length; ++i) {
                BpmOftenFlowUser bpmOftenFlowUser = new BpmOftenFlowUser();
                bpmOftenFlowUser.setId(UniqueIdUtil.getSuid());
                bpmOftenFlowUser.setOftenFlowId(id);
                bpmOftenFlowUser.setOwnerId(ids[i]);
                bpmOftenFlowUser.setOwnerName(names[i]);
                bpmOftenFlowUser.setRightType(rightType);
                this.bpmOftenFlowUserDao.insert((Object)bpmOftenFlowUser);
            }
        }
    }

    @Override
    @Transactional
    public void saveMyFlow(String userId, String userName, ArrayNode list) {
        this.removeByUserIdAndDefKeys(userId, null);
        ArrayList bpmOftenFlows = new ArrayList();
        list.forEach(i -> bpmOftenFlows.add(new BpmOftenFlow(userId, userName, i.get("defKey").asText())));
        this.saveBatch(bpmOftenFlows);
    }

    @Override
    public PageList<BpmOftenFlow> customQuery(String userId) {
        QueryFilter queryFilter = QueryFilter.build();
        PageBean pageBean = new PageBean(Integer.valueOf(1), Integer.valueOf(20));
        queryFilter.setPageBean(pageBean);
        IPage<BpmOftenFlow> result = ((BpmOftenFlowDao)this.baseMapper).customQuery((IPage<BpmOftenFlow>)this.convert2IPage(pageBean), this.convertGroupList(userId), (Wrapper<BpmOftenFlow>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    public PageList<BpmOftenFlow> query(QueryFilter<BpmOftenFlow> queryFilter) {
        return new PageList(((BpmOftenFlowDao)this.baseMapper).query((IPage<BpmOftenFlow>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BpmOftenFlow>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }

    private Map<String, String> convertGroupList(String userId) {
        List list = this.defaultUserGroupService.getGroupsByUserIdOrAccount(userId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("user", "'" + userId + "'");
        if (BeanUtils.isEmpty((Object)list)) {
            return map;
        }
        for (IGroup group : list) {
            String type = group.getGroupType();
            if (map.containsKey(type)) {
                String groupId = (String)map.get(type);
                groupId = groupId + ",'" + group.getGroupId() + "'";
                map.put(type, groupId);
                continue;
            }
            map.put(type, "'" + group.getGroupId() + "'");
        }
        return map;
    }

    @Override
    public String getBpmOftenFlowUsers(String oftenFlowId) {
        return this.toOwnerNameJson(this.bpmOftenFlowUserDao.getBpmOftenFlowUsers(oftenFlowId));
    }

    private String toOwnerNameJson(List<BpmOftenFlowUser> bpmOftenFlowUsers) {
        if (BeanUtils.isEmpty(bpmOftenFlowUsers)) {
            return "[]";
        }
        HashMap map = new HashMap();
        Map userTypeMap = this.currentUserService.getUserTypeMap(CurrentUserService.DEFAULT_OBJECT_RIGHTTYPE_BEAN);
        for (BpmOftenFlowUser user : bpmOftenFlowUsers) {
            List<BpmOftenFlowUser> list;
            String string = user.getRightType();
            if (map.containsKey(string)) {
                list = (List)map.get(string);
                list.add(user);
                continue;
            }
            list = new ArrayList();
            list.add(user);
            map.put(string, list);
        }
        ArrayNode ArrayNode2 = JsonUtil.getMapper().createArrayNode();
        for (Map.Entry<String, List<BpmOftenFlowUser>> entry : map.entrySet()) {
            ObjectNode json = this.userEntToJson(entry, userTypeMap);
            ArrayNode2.add((JsonNode)json);
        }
        return ArrayNode2.toString();
    }

    private ObjectNode userEntToJson(Map.Entry<String, List<BpmOftenFlowUser>> entry, Map<String, String> userTypeMap) {
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        String type = entry.getKey();
        String title = userTypeMap.get(type);
        jsonObj.put("type", type);
        jsonObj.put("title", title);
        if (type.equals("everyone")) {
            return jsonObj;
        }
        List<BpmOftenFlowUser> list = entry.getValue();
        String ids = "";
        String names = "";
        for (int i = 0; i < list.size(); ++i) {
            BpmOftenFlowUser user = list.get(i);
            if (i == 0) {
                ids = ids + user.getOwnerId();
                names = names + user.getOwnerName();
                continue;
            }
            ids = ids + "," + user.getOwnerId();
            names = names + "," + user.getOwnerName();
        }
        jsonObj.put("id", ids);
        jsonObj.put("name", names);
        return jsonObj;
    }
}

