/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.def.graph;

import com.artfess.activiti.def.graph.ilog.activiti.BPMNEdge;
import com.artfess.activiti.def.graph.ilog.activiti.BPMNShap;
import com.artfess.activiti.def.graph.ilog.activiti.ProcessDiagramGenerator;
import com.artfess.base.util.Dom4jUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.model.process.def.BpmDefLayout;
import com.artfess.bpm.api.model.process.def.BpmDefinition;
import com.artfess.bpm.api.model.process.def.BpmNodeLayout;
import com.artfess.bpm.api.service.BpmDefinitionService;
import com.artfess.bpm.api.service.DiagramService;
import com.artfess.bpm.natapi.graph.NatProcessImageService;
import java.awt.geom.Point2D;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

@Service(value="diagramService")
public class DefaultDiagramService
implements DiagramService {
    @Resource
    NatProcessImageService natProcessImageService;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    private static final String BPM_XML_NS = "xmlns=\"http://www.omg.org/spec/BPMN/20100524/MODEL\"";

    public InputStream getDiagramByBpmnDefId(String defId) {
        BpmDefinition bpmDefinition = this.bpmDefinitionService.getBpmDefinitionByDefId(defId);
        return this.natProcessImageService.getProcessImageByBpmnXml(bpmDefinition.getBpmnXml());
    }

    public InputStream getDiagramByDefId(String defId, Map<String, String> colourMap) {
        BpmDefinition bpmDefinition = this.bpmDefinitionService.getBpmDefinitionByDefId(defId);
        return this.natProcessImageService.getProcessImageByBpmnXml(bpmDefinition.getBpmnXml(), colourMap);
    }

    public BpmDefLayout getLayoutByDefId(String defId) {
        List<BPMNEdge> edges;
        BpmDefinition bpmDefinition = this.bpmDefinitionService.getBpmDefinitionByDefId(defId);
        String bpmnXml = bpmDefinition.getBpmnXml();
        BpmDefLayout bpmDefLayout = new BpmDefLayout();
        ArrayList<BpmNodeLayout> nodeLayoutlist = new ArrayList<BpmNodeLayout>();
        List<BPMNShap> shaps = ProcessDiagramGenerator.extractBPMNShap(bpmnXml);
        Point2D.Double[] points = ProcessDiagramGenerator.caculateCanvasSize(shaps, edges = ProcessDiagramGenerator.extractBPMNEdge(bpmnXml));
        double shiftX = points[0].getX() < 0.0 ? points[0].getX() : 0.0;
        double shiftY = points[0].getY() < 0.0 ? points[0].getY() : 0.0;
        float width = Math.round(points[1].getX() + 10.0 - shiftX);
        float height = Math.round(points[1].getY() + 10.0 - shiftY);
        float minX = Math.round(points[0].getX() - shiftX);
        float minY = Math.round(points[0].getY() - shiftY);
        minX = minX <= 5.0f ? 5.0f : minX;
        minY = minY <= 5.0f ? 5.0f : minY;
        bpmnXml = bpmnXml.replace(BPM_XML_NS, "");
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        List sequenceFlows = root.selectNodes("//sequenceFlow");
        HashMap<String, String> seqIdandName = new HashMap<String, String>();
        for (Object node : sequenceFlows) {
            String id = ((Element)node).attributeValue("id");
            String name = ((Element)node).attributeValue("name");
            seqIdandName.put(id, name);
        }
        List list = root.selectNodes("//bpmndi:BPMNShape");
        int subProcessNum = 1;
        HashMap<String, Integer> parentZIndexes = new HashMap<String, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            Element el = (Element)list.get(i);
            String id = el.attributeValue("bpmnElement");
            Element component = (Element)root.selectSingleNode("//*[@id='" + id + "']");
            if (component == null || component.getName().equalsIgnoreCase("participant") || component.getName().equalsIgnoreCase("lane")) continue;
            Element tmp = (Element)el.selectSingleNode("omgdc:Bounds");
            float x = Float.parseFloat(tmp.attributeValue("x"));
            float y = Float.parseFloat(tmp.attributeValue("y"));
            float w = Float.parseFloat(tmp.attributeValue("width"));
            float h = Float.parseFloat(tmp.attributeValue("height"));
            x = (float)((double)(x - minX + 5.0f) - shiftX);
            y = (float)((double)(y - minY + 5.0f) - shiftY);
            Element procEl = (Element)root.selectSingleNode("//process/descendant::*[@id='" + id + "']");
            if (procEl == null) continue;
            String type = procEl.getName();
            if (type.equals("endEvent")) {
                type = NodeType.END.getKey();
            }
            if (type.equals("startEvent")) {
                type = NodeType.START.getKey();
            }
            if (!"subProcess".equals(type) && !"callActivity".equals(type)) {
                Element multiObj = procEl.element("multiInstanceLoopCharacteristics");
                String signType = procEl.attributeValue("signType");
                if (multiObj != null && !"subProcess".equals(type)) {
                    type = NodeType.SIGNTASK.getKey();
                }
                if (StringUtil.isNotEmpty((String)signType)) {
                    type = NodeType.CUSTOMSIGNTASK.getKey();
                }
            }
            Element parent = procEl.getParent();
            String name = procEl.attributeValue("name");
            int zIndex = 10;
            String parentName = parent.getName();
            if (parentName.equals("subProcess")) {
                if (parent.getParent().getName().equals("subProcess")) {
                    ++subProcessNum;
                }
                if (type.equalsIgnoreCase("subProcess")) {
                    zIndex = (Integer)parentZIndexes.get(parent.attributeValue("id")) + 1;
                    parentZIndexes.put(id, zIndex);
                } else if (!type.equalsIgnoreCase("startEvent") && !type.equalsIgnoreCase("endEvent")) {
                    zIndex = 10 + subProcessNum;
                }
            } else if (type.equalsIgnoreCase("subProcess")) {
                parentZIndexes.put(id, zIndex);
            }
            BpmNodeLayout bpmNodeLayout = new BpmNodeLayout(id, name, NodeType.fromKey((String)type), x, y, w, h);
            if (type.equalsIgnoreCase("subProcess")) continue;
            nodeLayoutlist.add(bpmNodeLayout);
        }
        bpmDefLayout.setDefId(defId);
        bpmDefLayout.setName(bpmDefinition.getName());
        bpmDefLayout.setWidth(width);
        bpmDefLayout.setHeight(height);
        bpmDefLayout.setListLayout(nodeLayoutlist);
        return bpmDefLayout;
    }
}

