/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.def.impl.handler;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.Dom4jUtil;
import com.artfess.bpm.api.model.process.def.BpmFormInit;
import com.artfess.bpm.api.model.process.def.FieldInitSetting;
import com.artfess.bpm.api.model.process.def.FormInitItem;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.artfess.bpm.engine.def.DefXmlHandlerUtil;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.jamesmurty.utils.XMLBuilder;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.stereotype.Service;

@Service
public class BpmFormInitBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<BpmFormInit> {
    private String getFormInit(FormInitItem formInitItem) {
        List<FieldInitSetting> showFieldsSettings = formInitItem.getShowFieldsSetting();
        List<FieldInitSetting> saveFieldsSettings = formInitItem.getSaveFieldsSetting();
        if (BeanUtils.isEmpty(showFieldsSettings) && BeanUtils.isEmpty(saveFieldsSettings)) {
            return "";
        }
        try {
            XMLBuilder xmlBuilder = XMLBuilder.create((String)"ext:initItem").a("xmlns:ext", "http://www.jee-soft.cn/bpm").a("parentDefKey", formInitItem.getParentDefKey());
            if (BeanUtils.isNotEmpty(showFieldsSettings)) {
                xmlBuilder = xmlBuilder.e("ext:prevSetting");
                for (FieldInitSetting setting : showFieldsSettings) {
                    xmlBuilder.e("ext:fieldSetting").a("description", setting.getDescription()).e("ext:setting").d(setting.getSetting());
                }
                xmlBuilder = xmlBuilder.up();
            }
            if (BeanUtils.isNotEmpty(saveFieldsSettings)) {
                xmlBuilder = xmlBuilder.e("ext:saveSetting");
                for (FieldInitSetting setting : saveFieldsSettings) {
                    xmlBuilder.e("ext:fieldSetting").a("description", setting.getDescription()).e("ext:setting").d(setting.getSetting());
                }
            }
            return xmlBuilder.asString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    protected String getXml(String defId, String node, BpmFormInit formInit) throws Exception {
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defXml = def.getBpmnXml();
        Document doc = Dom4jUtil.loadXml((String)defXml);
        Element root = doc.getRootElement();
        List<BpmNodeDef> list = super.getNodeList(defId);
        Map<String, FormInitItem> map = formInit.getFormInitItemMap();
        for (BpmNodeDef nodeDef : list) {
            String nodeId = nodeDef.getNodeId();
            boolean isContain = map.containsKey(nodeId);
            String xml = "";
            if (isContain) {
                xml = this.getFormInit(map.get(nodeId));
            }
            String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:formInitSetting";
            String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
            Node el = root.selectSingleNode(xPath);
            Element elParent = (Element)root.selectSingleNode(xParentPath);
            if (el == null) {
                String propxml = "<ext:formInitSetting xmlns:ext=\"http://www.jee-soft.cn/bpm\" />";
                Document tempDoc = Dom4jUtil.loadXml((String)propxml);
                elParent.add(tempDoc.getRootElement());
            }
            String xPathItem = "//ext:*[@bpmnElement='" + nodeId + "']/ext:formInitSetting/ext:initItem[@parentDefKey='" + formInit.getParentDefKey() + "']";
            DefXmlHandlerUtil.handXmlDom(root, xml, xPath, xPathItem);
        }
        return root.asXML();
    }
}

