/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.filter;

import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.dto.PortalDataSensitive;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.interceptor.ResultSetFilter;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ContextThread;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.util.IPermissionCalc;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FormDataResultSetFilter
implements ResultSetFilter,
ContextThread {
    ThreadLocal<Map<String, PortalDataSensitive>> portalDataSensitiveLocal = new ThreadLocal();

    @Override
    public void handle(Object obj) {
        Map currentProfiles = null;
        Map<String, PortalDataSensitive> portalDataSensitive = this.portalDataSensitiveLocal.get();
        if (BeanUtils.isNotEmpty(portalDataSensitive)) {
            IPermissionCalc permissionCalc = AppUtil.getBean(IPermissionCalc.class);
            currentProfiles = permissionCalc.getCurrentProfiles();
        }
        if (obj instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)obj;
            for (HashMap hashMap : arrayList) {
                if (!(hashMap instanceof HashMap)) continue;
                HashMap row = hashMap;
                for (Map.Entry<String, Object> entry : row.entrySet()) {
                    if (!BeanUtils.isNotEmpty(portalDataSensitive)) continue;
                    this.handleField(entry, currentProfiles);
                }
            }
        }
        if (BeanUtils.isNotEmpty(portalDataSensitive)) {
            this.portalDataSensitiveLocal.remove();
        }
    }

    @Override
    public boolean support(String id, String sql, List<String> tableNames) {
        if (BeanUtils.isEmpty(tableNames)) {
            return false;
        }
        ArrayList<String> mappedStatementIds = new ArrayList<String>();
        mappedStatementIds.add("com.artfess.base.dao.CommonDao.queryByCustomSql");
        mappedStatementIds.add("com.artfess.base.dao.CommonDao.query");
        if (mappedStatementIds.contains(id)) {
            SystemConfigFeignService portalFeignService = AppUtil.getBean(SystemConfigFeignService.class);
            for (String tableName : tableNames) {
                CommonResult<PortalDataSensitive> portalDataSensitive;
                if (StringUtil.isEmpty(tableName) || !BeanUtils.isNotEmpty(portalDataSensitive = portalFeignService.getPortalDataSensitive("local", tableName)) || !portalDataSensitive.getState().booleanValue() || !BeanUtils.isNotEmpty(portalDataSensitive.getValue())) continue;
                this.add2Local(tableName, portalDataSensitive.getValue());
            }
            return this.isNotEmpty();
        }
        return false;
    }

    private boolean isNotEmpty() {
        Map<String, PortalDataSensitive> map = this.portalDataSensitiveLocal.get();
        return BeanUtils.isNotEmpty(map);
    }

    private void add2Local(String tableName, PortalDataSensitive portalDataSensitive) {
        Map<String, PortalDataSensitive> map = this.portalDataSensitiveLocal.get();
        if (BeanUtils.isEmpty(map)) {
            map = new HashMap<String, PortalDataSensitive>();
        }
        map.put(tableName, portalDataSensitive);
        this.portalDataSensitiveLocal.set(map);
    }

    private void handleField(Map.Entry<String, Object> entry, Map<String, Set<String>> currentProfiles) {
        try {
            Map<String, PortalDataSensitive> map = this.portalDataSensitiveLocal.get();
            Set<String> keySet = map.keySet();
            for (String tableName : keySet) {
                PortalDataSensitive portalDataSensitive = map.get(tableName);
                ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode(portalDataSensitive.getDesensitizationRules());
                GroovyScriptEngine groovyScriptEngine = AppUtil.getBean(GroovyScriptEngine.class);
                for (JsonNode jsonNode : arrayNode) {
                    Object value;
                    boolean hasRight;
                    if (!entry.getKey().equalsIgnoreCase(jsonNode.get("fieldName").asText()) || (hasRight = this.hasRight(jsonNode.get("rights").asText(), currentProfiles))) continue;
                    String groovyScript = jsonNode.get("groovyScript").asText();
                    String calType = jsonNode.get("calType").asText();
                    Object workMask = value = entry.getValue();
                    if (StringUtil.isNotEmpty(groovyScript) && "2".equals(calType)) {
                        HashMap<String, Object> vars = new HashMap<String, Object>();
                        vars.put(entry.getKey(), entry.getValue());
                        workMask = groovyScriptEngine.executeObject(groovyScript, vars);
                    } else {
                        int maxLength = 0;
                        if (BeanUtils.isNotEmpty(value) && value instanceof String) {
                            int endPosition;
                            String valueStr = value.toString();
                            maxLength = valueStr.length();
                            JsonNode rules = JsonUtil.toJsonNode(jsonNode.get("rules").asText());
                            int startPosition = rules.get("startPosition").asInt(0);
                            if (startPosition > maxLength) {
                                startPosition = maxLength;
                            }
                            if ((endPosition = rules.get("endPosition").asInt(maxLength)) > maxLength) {
                                endPosition = maxLength;
                            }
                            String pad = rules.get("pad").asText("*");
                            workMask = StringUtil.wordMask(valueStr, startPosition, endPosition, pad);
                        }
                    }
                    entry.setValue(workMask);
                }
            }
        }
        catch (IOException e) {
            throw new BaseException(ResponseErrorEnums.DESENSITIZATION);
        }
    }

    private boolean hasRight(String rights, Map<String, Set<String>> currentProfiles) throws IOException {
        IPermissionCalc permissionCalc = AppUtil.getBean(IPermissionCalc.class);
        ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode(rights);
        Iterator iterator = arrayNode.iterator();
        if (iterator.hasNext()) {
            JsonNode jsonNode = (JsonNode)iterator.next();
            return permissionCalc.hasRight(JsonUtil.toJsonString(jsonNode), currentProfiles);
        }
        return false;
    }

    @Override
    public void cleanAll() {
        this.portalDataSensitiveLocal.remove();
    }
}

