package com.artfess.uc.model;

import java.io.Serializable;

public class MatrixColField implements Serializable{
	private static final long serialVersionUID = 1L;
	
	//数据库字段名称 如： CONDK_aaa、CONDV_aaa、ROLE_cpjl
	protected String field;
	//列类型code 如： aaa、cpjl
	protected String code;
	//列类型名称
	protected String comment;
	
	protected MatrixColDef colDef ;
	/**
	 * 字段类型 
	 * id:主键
	 * ck:条件字段的key
	 * cv:条件字段的value
	 * ro:角色字段
	 */
	protected String ftype;
	
	public MatrixColField() {
		super();
	}
	

	public MatrixColField(String field, String code, String comment, String ftype, MatrixColDef colDef) {
		super();
		this.field = field;
		this.code = code;
		this.comment = comment;
		this.ftype = ftype;
		this.colDef = colDef;
	}


	public String getField() {
		return field;
	}

	public void setField(String field) {
		this.field = field;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getFtype() {
		return ftype;
	}

	public void setFtype(String ftype) {
		this.ftype = ftype;
	}


	public MatrixColDef getColDef() {
		return colDef;
	}


	public void setColDef(MatrixColDef colDef) {
		this.colDef = colDef;
	}

	
}
