package com.artfess.form.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 业务数据模板扩展
 *
 * @author 雷健
 * @company 广州宏天软件股份有限公司
 * @since 2020-07-07
 */
@TableName("FORM_DATA_TEMPLATE_EXTEND")
@ApiModel(value = "FormDataTemplateExtend对象", description = "业务数据模板扩展")
public class FormDataTemplateExtend extends BaseModel<FormDataTemplateExtend> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "提醒内容")
    @TableField("CONTENT_")
    private String content;

    @ApiModelProperty(value = "提醒次数")
    @TableField("COUNT_")
    private String count;

    @ApiModelProperty(value = "提醒对象ID")
    @TableField("OBJ_ID_")
    private String objId;

    @ApiModelProperty(value = "提醒内型")
    @TableField("TYPE_OBJ_")
    private String typeObj;

    @ApiModelProperty(value = "提醒对象名称")
    @TableField("OBJ_NAME_")
    private String objName;

    @ApiModelProperty(value = "提醒条件")
    @TableField("RULE_")
    private String rule;

    @ApiModelProperty(value = "业务数据模板Id")
    @TableField("FORM_DATA_TEMPLATE_ID")
    private String formDataTemplateId;

    @ApiModelProperty(value = "提醒主题")
    @TableField("SUBJECT_")
    private String subject;

    @ApiModelProperty("业务数据模板别名")
    @TableField(exist = false)
    private String alias;

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getCount() {
        return count;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public String getObjId() {
        return objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public String getTypeObj() {
        return typeObj;
    }

    public void setTypeObj(String typeObj) {
        this.typeObj = typeObj;
    }

    public String getObjName() {
        return objName;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getFormDataTemplateId() {
        return formDataTemplateId;
    }

    public void setFormDataTemplateId(String formDataTemplateId) {
        this.formDataTemplateId = formDataTemplateId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "FormDataTemplateExtend{" +
                "id=" + id +
                ", content=" + content +
                ", count=" + count +
                ", objId=" + objId +
                ", typeObj=" + typeObj +
                ", objName=" + objName +
                ", rule=" + rule +
                ", formDataTemplateId=" + formDataTemplateId +
                "}";
    }
}
