package com.artfess.base.entity;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.extension.activerecord.Model;

/**
 * 基础实体类
 *
 * @company 广州宏天软件股份有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2020年4月6日
 */
public abstract class BaseModel<T extends BaseModel<?>> extends Model<T>{
	private static final long serialVersionUID = 1L;
	
	/**
	 * 获取主键值
	 * @return
	 */
	public String getPkVal() {
		Serializable pkVal = pkVal();
		if(pkVal!=null) {
			return pkVal.toString();
		}
		return null;
	}
	
	protected Serializable pkVal() {
		TableInfo tableInfo = TableInfoHelper.getTableInfo(getClass());
		if (tableInfo != null) {
			return (Serializable) ReflectionKit.getMethodValue(this, tableInfo.getKeyProperty());
		}
        return null;
    }
}
