package com.artfess.yhxt.thirdparty.manager.impl;
import com.artfess.base.context.BaseContext;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.thirdparty.model.BizTpDevice;
import com.artfess.yhxt.thirdparty.dao.BizTpDeviceDao;
import com.artfess.yhxt.thirdparty.manager.BizTpDeviceManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.thirdparty.vo.TpDeviceCountVo;
import com.artfess.yhxt.thirdparty.vo.TpDeviceTypeCountVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 第三方传输设备基础信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
@Service
public class BizTpDeviceManagerImpl extends BaseManagerImpl<BizTpDeviceDao, BizTpDevice> implements BizTpDeviceManager {

    @Resource
    PermissionUtils permissionUtils;
    @Resource
    BaseContext baseContext;


    /**
     * 查询数量
     * @return
     */
    @Override
    public TpDeviceCountVo getDeviceCount(QueryFilter<BizTpDevice> queryFilter) {

        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())) {
            permissionUtils.addPermission(queryFilter);
        }

        PageBean pageBean = queryFilter.getPageBean();

        pageBean.setPageSize(-1);
        IPage<BizTpDevice> result = baseMapper.queryPage(convert2IPage(pageBean), map, convert2Wrapper(queryFilter, currentModelClass()));
        List<BizTpDevice> list = result.getRecords();
        TpDeviceCountVo countVo = new TpDeviceCountVo();

        if(null == list || list.isEmpty()){
            return countVo;
        }

        Map<Integer, List<BizTpDevice>> typeMap = list.stream().collect(Collectors.groupingBy(BizTpDevice::getType));

        //1.环境 2.作用 3.结构响应 4.结构变化

        List<BizTpDevice> list1 = typeMap.get(1);
        if(null != list1){
            countVo.setVibeCount(list1.size());
        }

        List<BizTpDevice> list2 = typeMap.get(2);
        if(null != list2){
            countVo.setMotiveCount(list2.size());
        }

        List<BizTpDevice> list3 = typeMap.get(3);
        if(null != list3){
            countVo.setStructuralCount(list3.size());
        }

        List<BizTpDevice> list4 = typeMap.get(4);
        if(null != list4){
            countVo.setVaryCount(list4.size());
        }


        return countVo;
    }


    /**
     * 设备分业
     * @param queryFilter
     * @return
     */
    @Override
    public PageList<BizTpDevice> pageVo(QueryFilter<BizTpDevice> queryFilter) {
        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())) {
            permissionUtils.addPermission(queryFilter);
        }

        IPage<BizTpDevice> result = baseMapper.queryPage(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList(result);
    }


    /**
     * 设备基础统计
     * @param queryFilter
     * @return
     */
    @Override
    public Map<String, TpDeviceTypeCountVo> getDeviceTypeCount(QueryFilter<BizTpDevice> queryFilter) {

        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())) {
            permissionUtils.addPermission(queryFilter);
        }

        IPage<BizTpDevice> result = baseMapper.queryPage(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));
        List<BizTpDevice> records = result.getRecords();
        if(null == records || records.isEmpty()){
            return new HashMap<>();
        }

        Map<String, List<BizTpDevice>> collect = records.stream().collect(Collectors.groupingBy(BizTpDevice::getDetailTypeName));

        HashMap<String, TpDeviceTypeCountVo> countVoHashMap = new HashMap<>();

        for (Map.Entry<String, List<BizTpDevice>> entry : collect.entrySet()) {
            List<BizTpDevice> list = entry.getValue();
            TpDeviceTypeCountVo countVo = new TpDeviceTypeCountVo();

            countVo.setTotal(list.size());
            //状态 i离线0 j在线1
            int i=0;
            int j=0;
            for (BizTpDevice bizTpDevice : list) {
                if(null != bizTpDevice.getState() && bizTpDevice.getState() == 0){
                    i++;
                }
                if(null != bizTpDevice.getState() && bizTpDevice.getState() == 1){
                    j++;
                }

            }
            countVo.setOfflineCount(i);
            countVo.setOnlineCount(j);


            countVoHashMap.put(entry.getKey(),countVo);
        }

        return countVoHashMap;
    }


    /**
     * 设备信息统计
     * @param queryFilter
     * @return
     */
    @Override
    public TpDeviceTypeCountVo deviceCountTotal(QueryFilter<BizTpDevice> queryFilter) {
        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())) {
            permissionUtils.addPermission(queryFilter);
        }
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(-1);
        TpDeviceTypeCountVo countVo = baseMapper.deviceCountTotal(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));

        return countVo;

    }
}
