package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.model.BizProjectScheduleManagement;
import com.artfess.yhxt.specialproject.model.BizProjectScheduleManagement;
import com.artfess.yhxt.specialproject.model.BizProjectScheduleManagement;
import com.artfess.yhxt.specialproject.dao.BizProjectScheduleManagementDao;
import com.artfess.yhxt.specialproject.manager.BizProjectScheduleManagementManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

/**
 * 项目进度管理表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-11
 */
@Service
public class BizProjectScheduleManagementManagerImpl extends BaseManagerImpl<BizProjectScheduleManagementDao, BizProjectScheduleManagement> implements BizProjectScheduleManagementManager {

    @Override
    public PageList<BizProjectScheduleManagement> queryBizProjectScheduleManagement(QueryFilter<BizProjectScheduleManagement> queryFilter) {
        IPage<BizProjectScheduleManagement> result =  baseMapper.queryBizProjectScheduleManagement(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizProjectScheduleManagement getBizProjectScheduleManagementById(String id) {
        BizProjectScheduleManagement bizProjectScheduleManagement = baseMapper.selectById(id);
        return bizProjectScheduleManagement;
    }
}
