package com.artfess.yhxt.contract.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.contract.model.ContractItem;
import com.artfess.yhxt.contract.manager.ContractItemManager;

/**
 * 合同明细表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-06
 */
@RestController
@RequestMapping("/contractItem/v1/")
@Api(tags = "合同明细接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ContractItemController extends BaseController<ContractItemManager, ContractItem> {

    @RequestMapping(value="getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询合同明细表",httpMethod = "POST")
    public PageList<ContractItem> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<ContractItem> queryFilter) {
        return baseService.queryContractItem(queryFilter);
    }
}
