package com.artfess.yhxt.check.regular.model;

import com.artfess.base.entity.BizModel;
import com.artfess.yhxt.basedata.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 桥梁经常检查表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-03
 */
@ApiModel(value="BizBridgeOftenCheck对象", description="桥梁经常检查表")
@TableName("BIZ_BRIDGE_OFTEN_CHECK")
@Data
public class BridgeOftenCheck extends BizModel<BridgeOftenCheck> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "桥梁id")
    @TableField("BRIGE_ID_")
    private String brigeId;

    @ApiModelProperty(value = "桥梁名称")
    @TableField("BRIGE_NAME_")
    private String brigeName;

    @ApiModelProperty(value = "所属公司ID")
    @TableField("COMPANY_ID")
    private String companyId;

    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "检查人")
    @TableField("RUMMAGER_")
    private String rummager;

    @ApiModelProperty(value = "检查日期")
    @TableField("CHECK_DATE_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date checkDate;

    @ApiModelProperty(value = "记录人")
    @TableField("NOTE_TAKER_")
    private String noteTaker;

    @ApiModelProperty(value = "天气")
    @TableField("WEATHER_")
    private String weather;

    @ApiModelProperty(value = "总体评价")
    @TableField("EVALUATE_")
    private String evaluate;

    @ApiModelProperty(value = "总体评价值")
    @TableField("EVALUATE_VALUE_")
    private String evaluateValue;

    @ApiModelProperty(value = "天气值")
    @TableField("WEATHER_VALUE_")
    private String weatherValue;

    @ApiModelProperty(value = "检查明细")
    @TableField("CHECK_DETAIL_JSON_")
    private String checkDetailJson;

}
