package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.yhxt.basedata.dao.RouteDao;
import com.artfess.yhxt.basedata.manager.RouteManager;
import com.artfess.yhxt.basedata.model.Route;
import com.artfess.yhxt.basedata.vo.RouteVo;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("RouteManager")
public class RouteManagerImpl extends BaseManagerImpl<RouteDao, Route> implements RouteManager {
    @Resource
    RouteDao routeDao;


    @Override
    public PageList<Route> queryRoute(QueryFilter<Route> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();

        IPage<Route> result = baseMapper.getRoute(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<Route>(result);

    }

    @Override
    public void updateRoute(String id) {
        UpdateWrapper<Route> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq(StringUtils.isNotBlank(id), "id_", id);
        updateWrapper.set("is_dele_", "1");
        routeDao.update(null, updateWrapper);
    }

    private boolean validateAllRoute(List<RouteVo> list){
        for (RouteVo routeVo : list) {
            if(StringUtil.isEmpty(routeVo.getName()) || StringUtil.isEmpty(routeVo.getCode())){
                return false;
            }
            if(!routeVo.getName().matches("^[\\s\\S]{1,30}$")
                    || !routeVo.getCode().matches("^[0-9a-z]{1,30}$")){
                return false;
            }
        }
        return true;
    }
}
