package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-19
 */
@ApiModel(value="ProjectAcceptance对象", description="项目验收信息表")
@TableName("biz_project_acceptance")
@Data
public class ProjectAcceptance extends BizModel<ProjectAcceptance> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "项目id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "项目name")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "子项目id")
    @TableField("SUBPROJECT_ID_")
    private String subprojectId;

    @ApiModelProperty(value = "子项目name")
    @TableField("SUBPROJECT_NAME_")
    private String subprojectName;

    @ApiModelProperty(value = "系统功能")
    @TableField("SYSTEM_FUNCTION_")
    private String systemFunction;

    @ApiModelProperty(value = "资料类型，数据字典，1.工程技术资料、2.工程综合资料、3工程财务资料 4.其他文件")
    @TableField("DATA_TYPE_")
    private Integer dataType;

    @ApiModelProperty(value = "上传人")
    @TableField("UPLOAD_USER_")
    private String uploadUser;

    @ApiModelProperty(value = "上传人单位")
    @TableField("UPLOAD_USER_COMPANY_NAME_")
    private String uploadUserCompanyName;

    @ApiModelProperty(value = "资料提供方，数据字典，1：业主方，2：监理方，3：施工方")
    @TableField("UPLOAD_ROLE_")
    private Integer uploadRole;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getSubprojectId() {
        return subprojectId;
    }

    public void setSubprojectId(String subprojectId) {
        this.subprojectId = subprojectId;
    }
    public String getSubprojectName() {
        return subprojectName;
    }

    public void setSubprojectName(String subprojectName) {
        this.subprojectName = subprojectName;
    }
    public String getSystemFunction() {
        return systemFunction;
    }

    public void setSystemFunction(String systemFunction) {
        this.systemFunction = systemFunction;
    }
    public Integer getDataType() {
        return dataType;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }
    public String getUploadUser() {
        return uploadUser;
    }

    public void setUploadUser(String uploadUser) {
        this.uploadUser = uploadUser;
    }
    public String getUploadUserCompanyName() {
        return uploadUserCompanyName;
    }

    public void setUploadUserCompanyName(String uploadUserCompanyName) {
        this.uploadUserCompanyName = uploadUserCompanyName;
    }
    public Integer getUploadRole() {
        return uploadRole;
    }

    public void setUploadRole(Integer uploadRole) {
        this.uploadRole = uploadRole;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ProjectAcceptance{" +
            "id=" + id +
            ", projectId=" + projectId +
            ", projectName=" + projectName +
            ", subprojectId=" + subprojectId +
            ", subprojectName=" + subprojectName +
            ", systemFunction=" + systemFunction +
            ", dataType=" + dataType +
            ", uploadUser=" + uploadUser +
            ", uploadUserCompanyName=" + uploadUserCompanyName +
            ", uploadRole=" + uploadRole +
            ", remarks=" + remarks +
        "}";
    }
}
