package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 工程质量管理质检单表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
@ApiModel(value="BizProjectManageQuality对象", description="工程质量管理质检单表")
@TableName("biz_project_manage_quality")
@Data
public class BizProjectManageQuality extends BizModel<BizProjectManageQuality> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "工程表id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "工程表name")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "质检单表id")
    @TableField("TEST_ID_")
    private String testId;

    @ApiModelProperty(value = "整改次数，默认值1")
    @TableField("REFORM_COUNT_")
    private Integer reformCount;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "质检时间")
    @TableField("TEST_TIME_")
    private LocalDate testTime;

    @ApiModelProperty(value = "质检地点")
    @TableField("TEST_LOCATION_")
    private String testLocation;

    @ApiModelProperty(value = "质检员")
    @TableField("TEST_USER_ID_")
    private String testUserId;

    @ApiModelProperty(value = "质检员")
    @TableField("TEST_USER_NAME_")
    private String testUserName;

    @ApiModelProperty(value = "有无质检问题（1-有、0-无)、默认值0")
    @TableField("TEST_RESULT_")
    private Integer testResult;

    @ApiModelProperty(value = "是否整改（1-是、0-否）、默认值0")
    @TableField("REFORM_FLAG_")
    private Integer reformFlag;

    @ApiModelProperty(value = "复查结果（0-待复查、1-通过、2-不通过)、初始值取决于有无质检问题")
    @TableField("CONFIRM_RESULT_")
    private Integer confirmResult;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getTestId() {
        return testId;
    }

    public void setTestId(String testId) {
        this.testId = testId;
    }
    public Integer getReformCount() {
        return reformCount;
    }

    public void setReformCount(Integer reformCount) {
        this.reformCount = reformCount;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public LocalDate getTestTime() {
        return testTime;
    }

    public void setTestTime(LocalDate testTime) {
        this.testTime = testTime;
    }
    public String getTestLocation() {
        return testLocation;
    }

    public void setTestLocation(String testLocation) {
        this.testLocation = testLocation;
    }

    public String getTestUserId() {
        return testUserId;
    }

    public void setTestUserId(String testUserId) {
        this.testUserId = testUserId;
    }

    public String getTestUserName() {
        return testUserName;
    }

    public void setTestUserName(String testUserName) {
        this.testUserName = testUserName;
    }

    public Integer getTestResult() {
        return testResult;
    }

    public void setTestResult(Integer testResult) {
        this.testResult = testResult;
    }
    public Integer getReformFlag() {
        return reformFlag;
    }

    public void setReformFlag(Integer reformFlag) {
        this.reformFlag = reformFlag;
    }
    public Integer getConfirmResult() {
        return confirmResult;
    }

    public void setConfirmResult(Integer confirmResult) {
        this.confirmResult = confirmResult;
    }
    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizProjectManageQuality{" +
            "id=" + id +
            ", testId=" + testId +
            ", reformCount=" + reformCount +
            ", remarks=" + remarks +
            ", testTime=" + testTime +
            ", testLocation=" + testLocation +
            ", testUserId=" + testUserId +
            ", testResult=" + testResult +
            ", reformFlag=" + reformFlag +
            ", confirmResult=" + confirmResult +
            ", validFlag=" + validFlag +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
        "}";
    }
}
